#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "ModeA.h"
#include "ModeB.h"

//Objects that are defined externallz
extern N5110 lcd;
extern BusOut leds;
extern Gamepad pad;

//Prototypes
/**
    * @brief Initialises the gamepad and the screen
    @code
    void init()
{
    lcd.init();
    pad.init();
}
 @endcode
    */
void init();

/**
    * @brief Prints menu
    @code
   void menu()
{
    lcd.clear();
    lcd.printString("Press button",0,0);
    lcd.printString("to select",0,1);
    lcd.printString("A: GAME",0,3);
    lcd.printString("B: RULES",0,4);
    lcd.refresh();
    wait(1.0);
}
 @endcode
    */
void menu();

/**
    * @brief Prints welcome message and countdown to menu
    @code
   void welcome()
{
    lcd.clear();
    lcd.setContrast(0.55);
    lcd.printString("  Welcome",3,2);
    lcd.refresh();
    wait(1.0);
    lcd.clear();
    lcd.printString("  Get Ready",2,2);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  4",4,3);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  3",4,3);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  2",4,3);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  1",4,3);
    lcd.refresh();
    wait(1.0);
}
 @endcode
    */
void welcome();

/**
    * @brief Calls ModeA funtion, including the game function
    @code
//function call mode A, including mane function of the game
void updateA()
{
    //if back is not pressed stay in mode A
    //if back is pressed go to menu
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        lcd.clear();
        modeA.Game(lcd);
        lcd.refresh();
    }
}
 @endcode
    */
void updateA();

/**
    * @brief Calls ModeB funtion, instructions
    @code
// function for calling mode B, instructions
void updateB()
{
    //if back is not pressed stay in mode B
    //if back is pressed go to menu
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        lcd.clear();
        modeB.screen(lcd);
        modeB.draw(lcd);
        lcd.refresh();
    }
}
 @endcode
    */
void updateB();

#endif