#include "main.h"

/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Ungureanu Maria
Username: el17mtu
Student ID Number: 201117608
Date: 09/05/2019
*/


//Objects
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
BusOut leds(PTA1,PTA2,PTC2,PTC3,PTC4,PTD3);
Gamepad pad;
ModeA modeA;
ModeB modeB;

int main()
{
    init();
    welcome();

    //call game functions
    while(1) {
        lcd.setContrast(0.55);
        menu();
        //when A is pressed turn on leds and call game function(mode A)
        while ( pad.check_event(Gamepad::A_PRESSED) == true) {
            pad.leds_on();
            wait(0.1);
            pad.leds_off();
            wait(0.1);
            modeA.initialise(lcd); //initialise the variables
            updateA(); //call main game function 
        }
        //when B is pressed turn on leds and call instructions function
        while ( pad.check_event(Gamepad::B_PRESSED) == true) {
            pad.leds_on();
            wait(0.2);
            pad.leds_off();
            wait(0.2);
            updateB();
        }

    }
}

// initialise pad and screen
void init()
{
    lcd.init();
    pad.init();
}

//print menu and options
void menu()
{
    lcd.clear();
    lcd.printString("Press button",0,0);
    lcd.printString("to select",0,1);
    lcd.printString("A: GAME",0,3);
    lcd.printString("B: RULES",0,4);
    lcd.refresh();
    wait(1.0);
}

//print welcome and count down to menu
void welcome()
{
    lcd.clear();
    lcd.setContrast(0.55);
    lcd.printString("  Welcome",3,2);
    lcd.refresh();
    wait(1.0);
    lcd.clear();
    lcd.printString("  Get Ready",2,2);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  4",4,3);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  3",4,3);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  2",4,3);
    lcd.refresh();
    wait(1.0);
    lcd.printString("  1",4,3);
    lcd.refresh();
    wait(1.0);
}

//function call mode A, including mane function of the game
void updateA()
{
    //if back is not pressed stay in mode A
    //if back is pressed go to menu 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) { 
        lcd.clear();
        modeA.Game(lcd);
        lcd.refresh();
    }
}

// function for calling mode B, instructions
void updateB()
{
    //if back is not pressed stay in mode B
    //if back is pressed go to menu 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        lcd.clear();
        modeB.screen(lcd);
        modeB.draw(lcd);
        lcd.refresh();
    }
}