#ifndef MODEB_H
#define MODEB_H

#include "mbed.h"
#include "main.h"
#include "N5110.h"
#include "Gamepad.h"

/** ModeB class

@brief Class displaying instructions
@author Maria Ungureanu
@date May 2019

*/

class ModeB
{

public:
    /** Constructor */
    ModeB();
    /** Destructor */
    ~ModeB();
    /**
    * @brief Refreshes and draws instructions on lcd
    @code
    void ModeB::draw(N5110 &lcd)
    {
     lcd.printString("INSTRUCTIONS",3,0);
    lcd.printString("Use Y, X ",0,1);
    lcd.printString("for square",0,2);
    lcd.printString("and bar",0,3);
    lcd.printString("Back:GAME",0,5);
    }
    @endcode
    */
    void draw(N5110 &lcd);
    /**
    * @brief Refreshes and draws instructions on lcd
    @code
    void ModeB::screen(N5110 &lcd)
    {
    lcd.clear(); //clear screen
    };
    @endcode
    */
    void screen(N5110 &lcd);
};
#endif