#ifndef MODEA_H
#define MODEA_H

#include "mbed.h"
#include "main.h"
#include "N5110.h"
#include "Gamepad.h"

/** ModeA class

@brief Class displaying instructions
@author Maria Ungureanu
@date May 2019

*/

class ModeA
{

public:
    /** Constructor */
    ModeA();
    /** Deconstructor */
    ~ModeA();


    /**
       * @brief Variables are defined
       * @param x_position @details x coordinate of square
       * @param y_position @details y coordinate of square
       * @param seped @details  speed of the square
       * @param gravity @details gravitational force
       * @param screen_width @details x coordinate of the bar
       * @param bar_width @details width of the bar
       * @param bar_speed @details speed of the bar
       * @param score @details score
       * @param size_top @details random length
       * @param size_bottom @details random length
       */
    void initialise(N5110 &lcd);

    /**
    * @brief Game function
    * @brief It draws the square, bars, it increments the score,
    * @brief moves the square and the bars.
    * @brief When the square and bar collide or the square is at
    * @brief the bottom of the screen it ends the game
    @code
    //game function
    void ModeA::Game(N5110 &lcd)
    {
    char buffer[14];
    sprintf(buffer,"%2d",score); //print score on the screen
    lcd.printString(buffer,70,0); // print the score at the right end of screen
    lcd.drawRect(x_position, y_position,6,6,FILL_BLACK); //draw the square
    lcd.refresh();

    // multiply gravity with 5 for a resonable speed
    if ( pad.check_event(Gamepad::Y_PRESSED) == true) {
        speed = speed - gravity*5;
    }

    //if the square drops to the bottom of screen- GAME OVER
    //redifine all parameters to 0, clear screen
    //press back to play again
    if (y_position > 44) {
        lcd.clear();
        lcd.printString("GAME OVER",6,2);
        lcd.printString("Press BACK",6,4);
        pad.tone(2000.0,0.3); //music
        lcd.refresh();
        bar_speed = 0;
        speed = 0;
        gravity = 0;
        y_position = 48;
        bar_width = 0;
        size_top = 0;
        size_bottom = 0;
        wait(0.5);
    }

    //if square goes to top part of screen, goes back down
    if (y_position < 0) {
        y_position = 0;
        speed = 0;
    }

    speed = speed + gravity; //increment the speed by the value of gravity
    y_position = y_position + speed; // as the square moves up, the position changes
    wait(0.1);

    //draw the 2 bars
    //the top one starts at y coordinate 0 and it has a height of size_top (random)
    //the bottom one starts size_bottom pixels above the edge of the screen
    lcd.drawRect(screen_width,0,bar_width,size_top,FILL_BLACK);
    lcd.drawRect(screen_width,48-size_bottom,bar_width,size_bottom,FILL_BLACK);
    lcd.refresh();

    // if the bar and square have the same x coordinates and
    // their y coordinates don't intersect, score increases by 1
    if ((screen_width == x_position) && (size_top < y_position)) {
        score = score + 1;
        lcd.clear();
        sprintf(buffer,"%2d",score); //update buffer
        lcd.printString("Reset",15,2);
        lcd.refresh();
        wait(1.0);
    }

    //if X is pressed random hights of the bars are genetrated
    if ( pad.check_event(Gamepad::X_PRESSED) == true) {
        srand(time(NULL));
        size_top = rand() % 15;
        srand(time(NULL));
        size_bottom = rand() % 15;
    }

    //if the bar and ball collide, Game Over
    //redifine all parameters to 0, clear screen
    //press back to play again
    if ((screen_width ==  x_position)&& (size_top >  y_position))  {
        lcd.clear();
        lcd.printString("GAME OVER",6,2);
        lcd.printString("Press BACK",6,4);
        pad.tone(2000.0,0.3);
        lcd.refresh();
        bar_speed = 0;
        speed = 0;
        gravity = 0;
        y_position = 48;
        bar_width = 0;
        size_top = 0;
        size_bottom = 0;
        wait(0.5);
    }

    //as the bar travels to the left, its position changes
    screen_width = screen_width - bar_speed;
    wait(0.1);
    }
    @endcode
    */
    void Game(N5110 &lcd);

//variables that are privatly defined
private:
    int x_position;
    int y_position;

    int gravity;
    int screen_width;
    int bar_width;
    int bar_speed;
    int speed;
    int score;

    int size_bottom;
    int size_top;


};
#endif