/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Melissa Hartmann
Username: el17m2h
Student ID Number: 201176603
Date: 09/05/2019
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Engine.h"


#ifdef WITH_TESTING
# include "tests.h"
#endif

struct UserInput {
    Direction d;
    float mag;
};

////////////////////////    OBJECTS     ///////////////////////////////////
N5110 lcd(PTC5,PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  // START, LCD SCE, LCD RST, LCD DC, LCD MOSI, LCD CLK, LCD Backlight
Gamepad pad;
Engine eng;
Doodler dood;

//////////////////////// FUNCTIONS DECLARED //////////////////////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
void check_score();
void game_over();


////////////////////////// MAIN CODE /////////////////////////////////////
int main()
{
    while(1) {
        init();
        welcome();
        int fps = 8;
        render();  // draws
        while(1) {
            render();
            eng.read_input(pad);
            check_score();
            wait(0.8f/fps);
            bool end_game = eng.get_game_over();
            if (end_game == true) {
                game_over();
                break;
            }
            if (pad.check_event(Gamepad::BACK_PRESSED) == true) {
                break;
            }
        }
    }
}


////////////////////////// FUNCTIONS CODE /////////////////////////////////////
void init()  // initialies all classes and libraries, LCD and Gamepad
{  
    lcd.init();
    lcd.setBrightness(1);
    lcd.setContrast(0.5),
    pad.init();
    eng.init();
}

// prints the current engine screen
void render() 
{
    lcd.clear();  // clears the previous screen display 
    eng.draw(lcd);  // sets the current updated screen display
    lcd.refresh();  // prints the current screen diplay 
}

// Starting menu screen display
void welcome()
{
    lcd.printString(" Doodle Jump! ",0,1);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh(); 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {  // infinite loop until START pressed
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

// Checks if the previous score has increased by one right after one to correct an infinite addition
void check_score()
{
    bool score_added = eng.get_score_check();
    eng.update(pad);
    bool updated_score_added = eng.get_score_check();
    if ( 
    (score_added == true) &&  // conditions indicate the score has been added sequentially after two updates
    (updated_score_added == true)  // this means the same floor has remained in the position that sets an addition, since it is
    )  // an impossibility for it to be another floor (floors have specific y-coordinate separation so there is never one next to another)
    {
        eng.subtract_score();  // subtracts the incorrect addition
    }  
}  

// Called on the main function to display the game over screen when the game has ended
void game_over()
{
    lcd.clear();
    lcd.printString("Game Over!",3,1);
    lcd.printString("Press back",3,3);
    int score = eng.get_score();
    char text[14]; 
    sprintf(text,"SCORE:%d", score);
    lcd.printString(text, 3, 5);
    lcd.refresh();
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}