#include "Floors.h"
Floors::Floors()
{
}
Floors::~Floors()
{
}


// Function to set the intial position of the floor at a specified input y-coordinate (from engine) and then sets a random 
// x-coordinate position. 
void Floors::init(int y, int width, int height)
{
    _height = height;  // defines the width and height as private variables
    _width = width;
    end_game = false;  // the read decision should be false initially so that the game is not ended as soon as it starts
    int decide = rand() % 2;  // x-coordinate initially random: 2-30 or 40-71 so doodler falls to bottom floor specified in engine
    if (decide == 0) {  // right
        _position.x = 2 + (rand()% 28);
    } else {  // left
        _position.x = 40 + (rand()% 31); // position is within screen parameters
    }
    _position.y = y;

}

// Prints the floor into the LCD screen by calling a function from the LCD to draw a 14 x 1 rectangle
void Floors::draw(N5110 &lcd)
{
    lcd.drawRect(_position.x, _position.y, _width, _height, FILL_BLACK);
    eny.draw(lcd);  // draws enemy
}

// Updates the position of the floor
void Floors::update(float doodler_pos_x, float doodler_pos_y, float _bullet_pos_x, float _bullet_pos_y)
{  // when they leave the screen they will re-appear in random x-coordinate so that 10 floors are always on screen
    // rectangle (1-82 & 9 - 48 )
    _doodler_pos_x = doodler_pos_x;
    _doodler_pos_y = doodler_pos_y;
    if (_position.y > 45 ) {  // the place decision bool is updated every time a floor re-appears
        _position.y = 9;
        _position.x = 1 + (rand()% 69);
        place = rand()% 6;
        if (place == 2) {  // 1/6 chance of placing a ghost
            eny.update(_position);
            put_enemy = true;
        } else {
            eny.erase();
            put_enemy = false;
        }
    }
    if (_doodler_pos_y < 16) {  // shift floors once doodler reaches 16 y-coordinate position threshold on the screen
        // I chose this value because testing with the doodler's jump, it allows the doodler to keep jumping on a floor
        // without it moving down and dissapearing
        _position.y  += 1;
    }
    check_enemy(_bullet_pos_x, _bullet_pos_y); 
}

// Function to check if doodler or bullet have collided with the enemy 
void Floors::check_enemy(float _bullet_pos_x, float _bullet_pos_y)
{
    enemy_position = eny.get_position();
    if (put_enemy == true) {
        eny.update(_position);
    }
    if (  // to check if the doodler has collided with the ghost
        (_doodler_pos_x + 6 <= enemy_position.x + 12) &&
        (_doodler_pos_x + 6 >= enemy_position.x) &&
        (_doodler_pos_y <= enemy_position.y + 11) &&
        (_doodler_pos_y >= enemy_position.y)
    ) {
        end_game = true;  // if doodler collides with enemy, the end_game variable will state the game should end
    }
    if (  // to check if the bullet has collided with the ghost
        (_bullet_pos_x <= enemy_position.x + 12) &&
        (_bullet_pos_x >= enemy_position.x) &&
        (_bullet_pos_y <= enemy_position.y + 11) &&
        (_bullet_pos_y >= enemy_position.y)
    ) {
        eny.erase();  // if bullet collides with enemy the erase function is called
    }
}


// Returns the current floor's position. It is called in the engine to compare its position with the other classes.
Vector2D Floors::get_position() { Vector2D p = {_position.x,_position.y}; return p; }


// Sets the position within the floor class by inputing the new values from the engine, where the function is called.
void Floors::set_position(Vector2D pos) { _position.x = pos.x; _position.y = pos.y; }

// The get_end_game function can be called in the engine to check if the game should end or not (if the doodler has collided
// with the enemy)
bool Floors::get_end_game() { return end_game; }