#include "Engine.h"

Engine::Engine()
{
}
Engine::~Engine()
{
}

// The function defines the screen's size, and the initial position of the doodler, the bullet 
// and the 6 floors. This is done by inputting the functions of initialization to the corresponding class. 
void Engine::init()
{
    screen_init();  // calls function to set the screen size
    doodler_vel_y = 1.1;
    doodler_pos_x = 35;
    doodler_pos_y = 26;
    _floors_width = 14;
    _floors_height = 1;
    _dood.init(doodler_pos_x,  doodler_pos_y, doodler_vel_y);  // sets the doodler's velocity
    _b.init(doodler_pos_x, doodler_pos_y);  // initially the bullet is at the doodler's position 
    _f_pos[1].y = 11;  // the y-position is defined in for the floors to have the same spacing between them throughout the whole game
    _f_pos[2].y = 18;
    _f_pos[3].y = 25;
    _f_pos[4].y = 30;
    _f_pos[5].y = 36;
    for(int i=0; i<6; i++) {  // for loop is used to repeat the process for the 6 elements in the array
        _f[i].init(_f_pos[i].y, _floors_width, _floors_height);  // it will initialize the 6 floors position
    }
    _f_pos[0].y = 42;
    _f_pos[0].x = 35;  // one floor always at the middle bottom initially so that the doodler always has where to fall
    _f[0].set_position(_f_pos[0]); // it sets the specific position of f[0] to correct the assigned one from the for loop
}


// This function initializes the initial score and screen parameters
void Engine::screen_init() 
{
    _score = 0;  // will in itially be 0 once the game begins and will increase as the doodler moves up
    _score_check = false;  // returned on main.cpp to correct if a floor stays at the constant position where a score is added
    _screen_pos_x = 1;  // the position of the screen is decided by its top left corner
    _screen_pos_y = 9;
    _screen_width = 82;
    _screen_height = 39;
}

// Sets the inputed gamepad read parameters in the engine file
// The function sets the inputed gamepad parameters for the direction of the joystick, its magnitude of
// inclination and checks if the button Y is pressed.
void Engine::read_input(Gamepad &pad)
{
    _d = pad.get_direction();  
    _mag = pad.get_mag();  
    _button_Y = pad.check_event(Gamepad::Y_PRESSED);  // a bool type variable so that it indicates if the event true or false
}

// Prints the doodler, floors and bullet by calling their calls the draw functions. For the floors, a
// for loop is used to repeat the process to draw the 6 floors. It also draws the screen rectangle and the score.
void Engine::draw(N5110 &lcd)
{
    lcd.drawRect(_screen_pos_x, _screen_pos_y, _screen_width, _screen_height, FILL_TRANSPARENT);  // screen drawn
    for(int i=0; i<6; i++) {  // for loop to call the draw functions of the 6 floors
        _f[i].draw(lcd);
    }
    _dood.draw(lcd);
    _b.draw(lcd);
    char text[14];  // buffer that stores the resulting string of text with score value (can display up to 14 characters)
    sprintf(text,"Score:%d", _score);  // sprint makes the text string include the text "Score:" and the current _score number
    lcd.printString(text, 2, 0.2);  // calls the function to print the string of text at the top left (2, 0.2) of the screen
}

// The function updates all the classes in the game by calling their update functions in a specific order.
// It checks the collision of the doodler with the floors by getting their current positions and inputing
// them to the "check_floors_collision" function, which will update the velocity of the doodler.
void Engine::update(Gamepad &pad)
{
    doodler_pos_x = _dood.get_position_x();  // variable represents the position from previous update (or initialization)
    doodler_pos_y = _dood.get_position_y();
    doodler_vel_y = (double)_dood.get_velocity_y();
    check_floors_collision(pad, doodler_pos_x, doodler_pos_y, doodler_vel_y);  // updates doodler's velocity
    _dood.update(_d, _mag);  // updates doodler's position within the class (but not on the engine file)
    updated_doodler_pos_x = _dood.get_position_x();  // gets the updated position of the doodler
    updated_doodler_pos_y = _dood.get_position_y();
    _b_pos_x = _b.get_position_x();  // gets the current position of the bullet
    _b_pos_y = _b.get_position_y();
    for(int i=0; i<6; i++) {
        _f[i].update(doodler_pos_x, doodler_pos_y, _b_pos_x, _b_pos_y);  // updates floor's x & y position
    }
    add_score();  // updates score
    check_fire(pad,updated_doodler_pos_x, updated_doodler_pos_y, doodler_pos_y);  // checks if doodler fired and sets the bullet's position
    set_game_over(updated_doodler_pos_y);  // check if the doodler has reached the screen's bottom to end the game
}

// Checks a collision by comparing the doodler's position with the floors' ones with 3 conditions (2 splitted into 2) 
// in order to specify the maximum and minimum position of doodler in the x and y coordinates. 
// If the conditions are met, it means there is a collision, which means the doodler's velocity will change direction
// (will be set to a negative value). The function also updates the velocity accordingly (make it increase/decrease by
//  multiplying it with constant values) so that the doodler accelerates or decelerates.
void Engine::check_floors_collision(Gamepad &pad, float doodler_pos_x, float doodler_pos_y, double doodler_vel_y)
{
    for(int i=0; i<6; i++) {
        _f_pos[i] = _f[i].get_position();
        if (
            (doodler_pos_x + 10 >= _f_pos[i].x) &&  // the right side of doodler (therefore +10)
            (doodler_pos_x + 2 <= _f_pos[i].x + 14) &&  // the +14 gets the right end of the floor and the +3 the left side of the doodler
            (doodler_pos_y + 13 >= _f_pos[i].y - 1) &&  // I decided to use a +2/-1 threshold since the doodler's positions depends
            (doodler_pos_y + 13 <= _f_pos[i].y + 2) &&  // on the velocity (which increases as it falls) and could jump to around 3 bits
            (doodler_vel_y > 0)  // below (not 1), esentially ignoring the possibility of it bin in certain bits
        ) {
            doodler_vel_y = -1.5;  // jumping starts
            pad.tone(100.0,0.1);  // sound indicates it jumped
        }
        _dood.set_velocity(doodler_vel_x, doodler_vel_y);  // sets the velocity within the doodler's class file
        _dood.check_velocity();  // if the velocity has changed it updates the velocity accordingly 
    }
}

// Checks if the doodler fires by checking the bullet's position and the input of the user (if the
// Y button has been pressed).
void Engine::check_fire(Gamepad &pad, float updated_doodler_pos_x, float updated_doodler_pos_y, float doodler_pos_y)
{
    if (
    (_button_Y == true) && // button Y is pressed
    (_b_pos_y == doodler_pos_y + 4)  // bullet not currently fired since its position equal to the doodler's trunk (hence the +4)
    ) 
    { 
        pad.tone(200.0,0.1);  // makes a sound to indicate it has fired
        _b.update(updated_doodler_pos_x, updated_doodler_pos_y );  // bullet updated to a new position in y-direction (upwards)
    } else if(_b_pos_y < doodler_pos_y + 4) {  // indicates bullet currently above doodler (it has already been fired)
        _b.update(updated_doodler_pos_x, updated_doodler_pos_y );  // ignores the button Y and bullet continues updating upwards
    } else {  // the update function will eventually return the bullet to the doodler's trunk position with it reaches the screen's top
        _b.init(updated_doodler_pos_x, updated_doodler_pos_y);  // init function will keep bullet at the doodler's trunks position
    }
}

// Increases score by checking the position of every floor (by using a for loop)
void Engine::add_score()
{
    for(int i=0; i<6; i++) {
        _f_pos[i] = _f[i].get_position();  // updates floor's x & y position
        if(_f_pos[i].y == 10) {  // limitation of floor remaining at this position corrected in main file (avoids infinite score addition)
            _score +=1;  // score every time a floor dissapears and re-appears at top of screen
            _score_check = true;  // used to correct the limitation on the main file
        } else {
            _score = _score;  // no score added
            _score_check = false;
        }
    }
}

// Sets the decision statement to end the game depending on the doodler's y-coordinate position
void Engine::set_game_over(float doodler_pos_y)
{
    for(int i=0; i<6; i++) {  // the for loop allows there to check if there is an enemy in any of the 6 floors
        enemy_collision[i] = _f[i].get_end_game();  // checks if the doodler has collided with the enemy
        if (
            (doodler_pos_y > 45) ||  // game ends if doodler has fallen down 
            (enemy_collision [i] == true) // or if it has collided with an enemy ghost
        ) {
            game_ends = true;  // indicates if game should end and the true/false statement is called on the main function
        } else {
            game_ends = false;  
        }
    }
}

// Function called on main.cpp to fix the limitation of the score addition and avoid an infinite addition
void Engine::subtract_score() { _score -=1; }  // subtracts one point from the current score

// Function that returns the current score. It is to be called on main.cpp to display in the game over screen the final score
int  Engine::get_score() { return _score; }

// Function that returns the decision to correct the addition limitation
bool  Engine::get_score_check(){ return _score_check; }  // only called in main file

// Function that returns the decision to end the game or not
bool Engine::get_game_over() { return game_ends; } // only called in the main file