#ifndef ENEMY_H
#define ENEMY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Enemy class
@brief Class for the ghost enemies
@author Melissa Hartmann
@date May 2019
*/

class Enemy
{
public:
    Enemy();
    ~Enemy();
    
    /**
    @brief Function to set the enemy's position on top of the floor's position
    @param Vector2D floor_pos
    @details The function uses the parameters of the enemy and the floor's size to place the enemy on top of the floor.
    */
    void update(Vector2D floor_pos);
    
    /**
    @brief Prints the enemy into the LCD screen
    @param N5110 &lcd
    @details The function draws a sprite of 12 x 12 bits that shows the image of the enemy ghost
    */
    void draw(N5110 &lcd);
    
    /**
    @brief Function to place the enemy at a position out of the screen's visibility
    @details The function draws sets the position of the enemy to a value where it will not be visible in the screen
    */
    void erase();
    
    /**
    @brief Returns the current enemy's position
    @details Gets the current value in the enemy's class for the enemy's position and returns it as a 2D vector
    */
    Vector2D get_position();

private:
    Vector2D _position;
};
#endif