#include "Enemy.h"
Enemy::Enemy()
{
}
Enemy::~Enemy()
{
}

// Function to set the enemy's position on top of the floor's position
void Enemy::update(Vector2D floor_pos)
{
    _position.x = floor_pos.x + 7 - 6;  // the + 7 for the centre of the floor and the + 6 for the centre of the ghost
    _position.y = floor_pos.y - 1 - 13;  // the - 1 is so that it is on top of the floor's position
    // and the + 15 is so that it considers the position of the feet of the ghost (not the top)
}

// Draws the enemy to the screen
void Enemy::draw(N5110 &lcd)
{
    const int image [12][12] = {
        {0,0,0,0,1,1,1,1,0,0,0,0},
        {0,0,1,1,0,0,0,0,1,1,0,0},
        {0,1,0,0,0,0,0,0,0,0,1,0},
        {1,0,0,1,0,0,0,0,1,0,0,1},
        {1,0,1,1,1,0,0,1,1,1,0,1},
        {1,0,0,1,0,0,0,0,1,0,0,1},
        {1,0,0,0,0,0,0,0,0,0,0,1},
        {1,0,0,0,0,0,0,0,0,0,0,1},
        {1,0,0,0,0,0,0,0,0,0,0,1},
        {1,1,1,0,0,1,1,0,0,1,1,1},
        {1,1,0,1,1,0,0,1,1,0,1,1},
        {1,0,0,0,1,0,0,1,0,0,0,1},
    };
    lcd.drawSprite(_position.x, _position.y, 12, 12,(int*)image);
}

// Called in floors file if enemy is meant to get erased (moves the ghost out of the screen's visibility
void Enemy::erase(){ _position.x = 90; _position.y = 50; }

Vector2D Enemy::get_position(){ Vector2D p = {_position.x,_position.y}; return p; }