#include "Doodler.h"

Doodler::Doodler()
{
}
Doodler::~Doodler()
{
}
// Function to set the intial position of the doodler is at the centre of the screen within the its class file. The
// values are inputed from the engine file and defined as private within the class file as indicated by the front underscore.
void Doodler::init(float position_x, float position_y, double velocity_y)
{
    _gravity = 1.1;  // positive value greater than one so when multiplied after each update it will increase the velocity down
    _up = -0.6;  // negative value smaller than one in magnitude so it will decrease the velocity in an upward direction
    _position_x = position_x;  // inputed from the engine file and float type to allow fractions of the velocity to be added
    _position_y = position_y;  // inputed from the engine file and float type to allow fractions of the velocity to be added
    _velocity_y = velocity_y; // inputed from engine and double type to allow it to decelerate to a small enough value
}

// Draws the doodler's image by calling the sprite function from the LCD screen file. The function creates
// a constant 13 x 15 bit drawing (hence the "const") with position indicated by the first top left bit. 
// By making it remain constant, the black and white spaces in the drawing will not be affected by the other elements
// shown in the screen (like the floors). 
void Doodler::draw(N5110 &lcd)
{
        const int image [15][13] = {  // it will remain constant when displayed on the screen
        {0,0,1,1,1,1,1,0,0,0,0,0,0},
        {0,1,0,0,0,0,0,1,0,0,0,0,0},
        {1,0,0,0,0,0,0,0,1,0,0,0,0},
        {1,0,0,0,0,0,0,0,1,0,0,1,0},
        {1,0,0,0,0,1,0,1,0,1,1,0,1},
        {1,0,0,0,0,0,0,0,0,1,0,1,0},
        {1,0,0,0,0,0,0,0,1,1,0,0,0},
        {1,1,1,1,1,1,1,1,1,0,0,0,0},
        {1,0,0,0,0,0,0,0,1,0,0,0,0},
        {1,1,1,1,1,1,1,1,1,0,0,0,0},
        {1,1,1,1,1,1,1,1,1,0,0,0,0},
        {0,1,0,0,1,0,0,1,0,0,0,0,0},
        {0,1,0,0,1,0,0,1,0,0,0,0,0},
        {0,1,1,0,1,1,0,1,1,0,0,0,0},
    };
    lcd.drawSprite(_position_x, _position_y, 15, 13, (int*) image);  // calls sprite function from LCD file to display the image defined
}

// Function to update the position. It is splitted into two functions that update the x and y coordinate positions.
void Doodler::update(Direction d, float mag) { update_x(d, mag); update_y(); }

// The function updates the x-coordinate position of the doodler. It reads the input from the gamepad (movement of joystick) 
// and defines the velocity_x as a variable dependent on the magnitude of inclination read, so that the velocity changes accoordingly
// and the doodler acceleratate or remain at a constant velocity. It uses the direction input to decide in an if statement if the 
// position_x should increase or decrease in value. If the joystick is moved west (left), the velocity is subtracted, otherwise it is 
// added. It then checks the doodler does not leave the screen rectangle (39 x 82) in the x-direction by making it remain in the its 
// position.
void Doodler::update_x(Direction d, float mag)  
{
    _velocity_x = int(mag*5.0f); // int holds that value for 5 frames
    if (d == W || d == NW || d == SW) { // considers direction is left at an angle or not
        _position_x -= _velocity_x;  // subtracts velocity from current position for it to move left
    } else if (d == E || d == NE || d == SE) {  // considers direction is right at an angle or not
        _position_x += _velocity_x;  // adds velocity from current position for it to move to the right of the screen
    }
    if (_position_x > 70) {  // right side
        _position_x = 83 - 13; // max position is the edge of the screen - doodler's x-size (to consider the right side of the image)
    }
    if (_position_x < 2) { // left side
        _position_x = 2;  // minimum position is the edge of the screen (1) + a space bit in between the doodler
    }
}


// The function updates the y-coordinate position of the doodler. It has no input paramenters from the gamepad, 
// since it only depends on the floors below it. It checks the direction of the velocity (dependent on the collision
// with the floors) to check the direction of the doodler's movement (depending on if it is jumping or falling). It also 
// checks the doodler remains within the y-coordinates of the screen (only top edge, because the bottom edge means the
// game ends).
void Doodler::update_y(){
    if (_position_y < 9) { // top edge of rectangle reached
        _position_y = 9;  // position remains in the top edge
    }
    if ((double)_velocity_y >= 0.00) { // indicates it should move down (no jump) since it is falling/begining to fall
        _position_y += _velocity_y;  // velocity added so that it moves down
    } else if ((double)_velocity_y < 0.00) { // indicates it is moving up (or that jump has started) until vel = 0
        _position_y += _velocity_y*5;  // velocity is currently negative so it is added for the position to move up 
    }
}


// The function checks the current velocity of the doodler and depending on its direction
// (positive or negative) it will decide if the doodler's updated velocity will remain the same or
// change direction (jump).
void Doodler::check_velocity()
{
    if ((double)_velocity_y > 0.00) { // indicates it is falling down (no jump)
        _velocity_y = (double)_velocity_y*(double)_gravity;  // makes it keep falling down (accelerating)
    } else if ( (double)_velocity_y == 0.00) {  // indicates it has decelerated upwards completely
        _velocity_y = (double)_gravity;  // sets velocity to a initial downwards direction
    } else if ((double)_velocity_y < 0.00) {  // indicates it is moving upwards (or jump has started)
        _velocity_y = -((double)_velocity_y * (double)_up); // makes it keep decelerating up (0<_up<1 so _velocity.y reaches 0)
        if (fabs((double)_velocity_y) < 0.008) { // uses a 0,008 threshold for the velocity not to decelerate infinitely
            _velocity_y = 0.00;  // sets the velocity to 0 so that it indicates it has decelerated completely
        }
    }
}

// Returns the current doodler's position in the x-axis. It is called in the engine to compare its position with the other classes.
float Doodler::get_position_x() { float p_x = _position_x; return p_x; }

// Returns the current doodler's position in the y-axis. It is called in the engine to compare its position with the other classes.
float Doodler::get_position_y() { float p_y = _position_y; return p_y; }

// Returns the current doodler's velocity in the x-axis. It is called in the engine to compare its position with the other classes.
float Doodler::get_velocity_x() { float v_x = _velocity_x; return v_x; }

// Returns the current doodler's velocity in the y-axis. It is called in the engine to compare its position with the other classes.
double Doodler::get_velocity_y() { double v_y = _velocity_y; return v_y; }

// Sets the position within the doodler class by inputing the new values from the engine, where the function is called.
void Doodler::set_position(float pos_x, float pos_y) { _position_x = pos_x; _position_y = pos_y; }

// Sets the velocity within the doodler class by inputing the new values from the engine, where the function is called.
void Doodler::set_velocity(float vel_x, double vel_y) { _velocity_x = vel_x; _velocity_y = (double)vel_y; }