#ifndef BULLET_H
#define BULLET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Bullet class
@brief Class for the bullet
@author Melissa Hartmann
@date May 2019
*/
class Bullet
{
public:
    Bullet();
    ~Bullet();
    /**
    @brief defines the initial position of the bullet
    @param float dood_pos_x
    @param float dood_pos_y
    @details The intial position is in same position as doodler's trunk end (which is why I am adding the 12 and 4 to the doodler's position)
    */
    void init(float dood_pos_x, float dood_pos_y);

    /**
    @brief Prints bullet into LCD screen
    @param N5110 &lcd
    @details The function draws a circle of radius 1 into the LCD screen
    */
    void draw(N5110 &lcd);

    /**
    @brief Updates bullet's position
    @param N5110 &lcd
    @details The function draws a circle of radius 1 into the LCD screen
    */
    void update(float dood_pos_x, float dood_pos_y);

    /**
    @brief defines the initial position of the bullet
    @param float dood_pos_x
    @param float dood_pos_y
    @details The intial position is in same position as doodler's trunk end (which is why I am adding the 12 and 4 to the doodler's position)
    */
    float get_position_x();

    /**
    @brief defines the initial position of the bullet
    @param float dood_pos_x
    @param float dood_pos_y
    @details The intial position is in same position as doodler's trunk end (which is why I am adding the 12 and 4 to the doodler's position)
    */
    float get_position_y();

    /**
    @brief defines the initial position of the bullet
    @param float dood_pos_x
    @param float dood_pos_y
    @details The intial position is in same position as doodler's trunk end (which is why I am adding the 12 and 4 to the doodler's position)
    */
    void set_position(float pos_x, float pos_y);



private:
    int _radius;
    float _position_x;
    float _position_y;
};
#endif