#ifndef TESTS_H
#define TESTS_H

#include "N5110.h"
#include "Gamepad.h"
#include "mbed.h"
#include "Skateboarder.h"
#include "Coin.h"
#include "Fire.h"
#include "Platforms.h"

/** Tests Class
* @brief Allows the user to input a set stimulus to test sprites by printing to LCD and terminal. 
* @author Lewis Wooltorton
* @date May 2019

@code

#include "N5110.h"
#include "Gamepad.h"
#include "mbed.h"
#include "Tests.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Tests test;  // Create a test object if tests are to be done.

void init_game();

int main() {
  init_game();
  while(1) {
    lcd.setContrast(gamepad.read_pot());  // Contrast is controlled by pot.
    lcd.clear();  
    // Blelow line is an example of testing sprites. See documentation for 
    // parameters and details.
    test.run_tests(1,1,Left,Skate_right,20,20,20,10,30,50,5,lcd);     
    lcd.refresh();
    wait(0.01);  
  }     
}  
 
void init_game() {
  test.init(20);  // Argument is the vertical position of test platforms.
  gamepad.init();
  lcd.init(); 
  lcd.normalMode();      
  lcd.setBrightness(0.5); 
}
@endcode

*/

class Tests {
 public:
  // Constructor and destructor.
  /**
  * @brief Constructor 
  * @details Non user specified.
  */
  Tests();
  /**
  * @brief Destructor 
  * @details Non user specified.
  */
  ~Tests();
  
  // Member methods.
  /**
  * @brief Initalises the Tests.
  * @param platforms_y @details The vertical position of the platforms
  */ 
  void init(int platforms_y); 
  /**
  * @brief Runs all the Tests with input stimulus.
  * @param joy_x @details The x coordinate of the joystick
  * @param joy_y @details The y coordinate of the joystick
  * @param sprite @details the skateboarder sprite to be printed (from the enum class Sprite_value)
  * @param coin_x @details The x coordinate of the coin
  * @param coin_y @details The y coordinate of the coin
  * @param fire_y @details The y coordinate of the fire
  * @param line_1_start @details The starting x coordinate of line 1
  * @param line_2_start @details The starting x coordinate of line 2
  * @param line_3_start @details The starting x coordinate of line 3
  * @param line_length @details The length of each line in the platform object
  * @param &lcd @details The lcd object from the N5110 class
  */
  void run_tests(float joy_x, float joy_y, Sprite_value sprite, int coin_x, int coin_y, int fire_y, int line_1_start, int line_2_start, int line_3_start, int line_length, N5110 &lcd);
  
 private:
  void test_skater(float joy_x, float joy_y, Sprite_value sprite, N5110 &lcd);
  void test_coin(int coin_x, int coin_y, N5110 &lcd);
  void test_fire(int fire_y, N5110 &lcd);
  void test_platforms(int line_1_start, int line_2_start, int line_3_start, int line_length, N5110 &lcd);
  
  Skateboarder _skater;
  Coin _coin;
  Fire _fire;
  Platforms _platforms;
  int _moving_counter;
  Line _line_1;
  Line _line_2;
  Line _line_3;
};
#endif
  