#include "Tests.h"

Tests::Tests() {} 

Tests::~Tests() {}

void Tests::init(int platforms_y) {
  // Initialise objects.
  _platforms.init(platforms_y);  // Argument is vertical position of platforms.
  _coin.init();
  _fire.init();
  _moving_counter = 0;
}

void Tests::run_tests(float joy_x, 
               float joy_y,
               Sprite_value sprite,
               int coin_x,
               int coin_y,
               int fire_y,
               int line_1_start,
               int line_2_start,
               int line_3_start,
               int line_length,
               N5110 &lcd) {
  // Runs tests for each sprite with user input stimulus.
  test_skater(joy_x, joy_y, sprite, lcd);
  test_coin(coin_x, coin_y, lcd);
  test_fire(fire_y, lcd);
  test_platforms(line_1_start,
                 line_2_start,
                 line_3_start, 
                 line_length, 
                 lcd);
}

void Tests::test_skater(float joy_x,
                        float joy_y, 
                        Sprite_value sprite, 
                        N5110 &lcd) {
  // Prints the skater sprite at coords with given direction and sprite.
  lcd.clear(); 
  _skater.set_x_position_and_sprite(joy_x, 
      _moving_counter, 
      Left,
      joy_y);  // Sets object with input stimulus. Skate driection is set to 
  // left as default, this will not matter and be overwritten when sprite is
  // specified by user.    
  lcd.drawSprite(_skater.get_x_position(),_skater.get_y_position(),17,10,
                (int *)_skater.get_sprite(sprite));  // Prints object.
  lcd.refresh();
  wait(1);
}

void Tests::test_coin(int coin_x, int coin_y, N5110 &lcd) {
  // Prints the coin at coords from input.
  lcd.clear();
  _coin.generate_coin();  // Updates coin sprite.
  _coin.set_coin(coin_x,coin_y);  // Sets object with input stimulus.
  lcd.drawSprite(_coin.get_coin_x(),_coin.get_coin_y(),5,5,
                 (int*)_coin.get_coin_sprite());
  lcd.refresh();
  wait(0.5);  // Repeat so different sprites of coin are seen more often.
  lcd.clear();
  _coin.generate_coin();
  _coin.set_coin(coin_x,coin_y);
  lcd.drawSprite(_coin.get_coin_x(),_coin.get_coin_y(),5,5,
                 (int*)_coin.get_coin_sprite());
  lcd.refresh();
  wait(0.5);
}

void Tests::test_fire(int fire_y, N5110 &lcd) {
  // Prints the fire at given input y coord (x is not accessible to user as 
  // automatically moves across screen).
  lcd.clear();
  _fire.generate_fire();  // Set fire x coord and sprite.
  lcd.drawSprite(_fire.get_fire_x(),fire_y,5,8,(int*)_fire.get_fire_sprite());
  lcd.refresh();
  wait(0.5);  // Repeat so different sprites of fire are seen more often.
  lcd.clear();
  _fire.generate_fire();
  lcd.drawSprite(_fire.get_fire_x(),fire_y,5,8,(int*)_fire.get_fire_sprite());
  lcd.refresh();
  wait(0.5);
  // Print coords of fire (as it is moving) to moniter changes.
  printf("Fire x coord = %d, y coord = %d \n",_fire.get_fire_x(), fire_y);  
}

void Tests::test_platforms(int line_1_start,
                 int line_2_start,
                 int line_3_start, 
                 int line_length, 
                 N5110 &lcd) {
  // Prints three lines from the single platform object, with lengths and 
  // starting positions determined by input stimulus.
  lcd.clear();
  // Set (with length) and get each line.
  _platforms.set_line_1(line_length);
  _line_1 = _platforms.get_line_1(); 
  _platforms.set_line_2(line_length);
  _line_2 = _platforms.get_line_2();
  _platforms.set_line_3(line_length);
  _line_3 = _platforms.get_line_3();
  // Print all three lines.
  lcd.drawLine(_line_2.x_start,_line_2.y,_line_2.x_end,
               _line_2.y,FILL_BLACK);
  lcd.drawLine(_line_1.x_start,_line_1.y,_line_1.x_end,
               _line_1.y,FILL_BLACK);
  lcd.drawLine(_line_3.x_start,_line_3.y,_line_3.x_end,
               _line_3.y,FILL_BLACK);
  lcd.refresh();
  // Print start coords of each line (as they are moving) to moniter changes.
  printf("Line 1 start = %d,\n Line 2 start = %d,\n Line 3 start = %d \n", 
         _line_1.x_start,
         _line_2.x_start,
         _line_3.x_start);
  wait(1);                
}
                 
                 
                 