#ifndef PLATFORMS_H
#define PLATFORMS_H

#include "mbed.h"

/** Line struct */
struct Line {  
  int x_start; /**< Integer for the start of the line. */
  int x_end; /**< Integer for the end of the line. */
  int y; /**< Integer for the Y position of the line. */
};

/** Platforms Class
* @brief Generates a row of platforms (lines) for the skateboarder to move on 
* @author Lewis Wooltorton
* @date March 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Platforms.h"
#include <cstdlib>
#include <ctime>

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Platforms _lower_platforms;

int _length_1;
int _length_2;
int _length_3;

Line _lower_line_1;
Line _lower_line_2;
Line _lower_line_3;

int main() {
  _lower_platforms.init(20);  // Set vertical height to 20;
  while(1) {
    
    // Set all the line lengths to random values.
    _length_1 = (rand() %20) + 10;    
    _lower_platforms.set_line_1(_length_1);
    _lower_line_1 = _lower_platforms.get_line_1(); 
    _length_2 = (rand() %20) + 10;        
    _lower_platforms.set_line_2(_length_2);
    _lower_line_2 = _lower_platforms.get_line_2();
    _length_3 = (rand() %20) + 10;       
    _lower_platforms.set_line_3(_length_3);
    _lower_line_3 = _lower_platforms.get_line_3();
    
    // Print lines.
    lcd.drawLine(_lower_line_2.x_start,_lower_line_2.y,_lower_line_2.x_end,
               _lower_line_2.y,FILL_BLACK);
    lcd.drawLine(_lower_line_1.x_start,_lower_line_1.y,_lower_line_1.x_end,
               _lower_line_1.y,FILL_BLACK);
    lcd.drawLine(_lower_line_3.x_start,_lower_line_3.y,_lower_line_3.x_end,
               _lower_line_3.y,FILL_BLACK);
  }  
}    

@endcode
*/

class Platforms {
 public:
  // Constructor and Destructor.
  /**
  * @brief Constructor @details Non user specified.
  */
  Platforms();
  /**
  * @brief Destructor @details Non user specified.
  */
  ~Platforms();
  
  // Mutators.
  /** 
  * @brief Initialises Platforms object.
  * @param y @details The initial vertical coordinate of the platforms. 
  */
  void init(int y);
  /**
  * @brief Sets all parameters of line 1.
  * @param length @details the length of line 1
  */
  void set_line_1(int length);
  /**
  * @brief Sets all parameters of line 2.
  * @param length @details the length of line 2
  */
  void set_line_2(int length);
  /**
  * @brief Sets all parameters of line 3.
  * @param length @details the length of line 3
  */
  void set_line_3(int length);
  
  // Accessors.
  /**
  * @brief Gets line 1.
  * @returns Line 1 (type: struct, Line)
  */
  Line get_line_1();
  /**
  * @brief Gets line 2.
  * @returns Line 2 (type: struct, Line)
  */
  Line get_line_2();
  /**
  * @brief Gets line 3.
  * @returns Line 3 (type: struct, Line)
  */
  Line get_line_3();
    
 private:
  Line _line_1;
  Line _line_2;
  Line _line_3;
};
#endif


