#include "Platforms.h"

// Constructor and destructor.
Platforms::Platforms() {} 

Platforms::~Platforms() {}

void Platforms::init(int y) {
  // Starting values for the platforms.
  _line_1.x_start = 0;
  _line_1.x_end = 15;
  _line_1.y = y;
  _line_2.x_start = 25;
  _line_2.x_end = 60;
  _line_2.y = y;
  _line_3.x_start = 60;
  _line_3.x_end = 80;
  _line_3.y = y;
}

void Platforms::set_line_1(int length) {
  // Lines move from R to L via de-incrementing.
  _line_1.x_start--; 
  if (_line_1.x_start < 80 - length) _line_1.x_end--;  // Only move end of the
  // line if the line length is fully on the screen.
  if (_line_1.x_start <= 0) _line_1.x_start = 0;  // Terminate line 1 start at 0 
  // when it reaches LHS of screen so it does not go negative.
  if (_line_1.x_end <= 0) {  // Start Drawing line again from start once the end 
  // has reaches LHS of screen.
    _line_1.x_start = 80;
    _line_1.x_end = 80;
  }      
}
           
void Platforms::set_line_2(int length) {
  // Same as set_line_1.
  _line_2.x_start--;
  if (_line_2.x_start < 80 - length) _line_2.x_end--;
  if (_line_2.x_start <= 0) _line_2.x_start = 0;
  if (_line_2.x_end <= 0) {
    _line_2.x_start = 80;
    _line_2.x_end = 80;
  }      
}
    
void Platforms::set_line_3(int length) {
  // Same as set_line_1.
  _line_3.x_start--;
  if (_line_3.x_start < 80 - length) _line_3.x_end--;
  if (_line_3.x_start <= 0) _line_3.x_start = 0;
  if (_line_3.x_end <= 0) {
    _line_3.x_start = 80;
    _line_3.x_end = 80;
  }  
}
    
Line Platforms::get_line_1() {
  return _line_1;
}

Line Platforms::get_line_2() {
  return _line_2;
}
    
Line Platforms::get_line_3() {
  return _line_3;
}
    
    
   

