#include "Menu.h"

// Define sprite arrays.
int menu_sprite[23][80] =   { 
  { 0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1 },
  { 0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,
  1,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,
  0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
  0,0,0,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,
  0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,
  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,1,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,
  1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,1,
  1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,
  1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,
  1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0 }
};

// Define the finite state machine for three different states: running game, 
// display
// menu and display controls, {output,{a,b,c,d}} where a,b,c,d are inputs.
// The outputs have been assigned to 0,1,2.  
// There are four different relevant input combinations that have been assigned 
// to: 0,1,2,3.
State _fsm[3] = { 
  {0,{0,1,0,0}},
  {1,{1,1,0,2}},
  {2,{2,1,2,0}}
};   

// Constructor and destructor.
Menu::Menu() {}

Menu::~Menu() {}

void Menu::init() { 
  // Starting setup of menu.
  _state = 1;  // Starting state is the menu.  
  _controller.init();
  // Initialise counters for musical tune.
  _tone_flag = false;
  _tone_counter = 0;
  _chord_counter = 0;
}

void Menu::run(N5110 &lcd, Gamepad &gamepad) {
  set_input(gamepad.check_event(Gamepad::START_PRESSED), 
    gamepad.check_event(Gamepad::BACK_PRESSED),
    gamepad.check_event(Gamepad::X_PRESSED));
  // Select the current output, execute that output via the output function and 
  // update to the next state depending on the input.
  _output = _fsm[_state].output;
  output(lcd, gamepad);
  _state = _fsm[_state].next_state[_menu_input];    
}

void Menu::output(N5110 &lcd, Gamepad &gamepad) {
  // 0, 1 and 2 have been assigned to the output of each state respectively.
  if (_output == 0) {
    run_game(lcd, gamepad);  // Runs the main game loop.
  } else if (_output == 1) {
    display_menu(lcd, gamepad);  // Displays the main menu.
  } else {
    display_controls(lcd, gamepad);  // Displayes the control page.
  }
}

void Menu::set_input(bool start, bool back, bool x) {
  // 0, 1, 2, 3 have been assigned to each relevant input combination.
  if (!start && !back && !x) {  // Nothing is pressed.
    _menu_input = 0;  
  } else if (!start && back) {  // Only back is pressed.
    _menu_input = 1;  
  } else if (start && !back) {  // Only start is pressed.
    _menu_input = 2;  
  } else if (x) {  // Only X is pressed.
    _menu_input = 3; 
  }
} 

void Menu::run_game(N5110 &lcd, Gamepad &gamepad) {
  _controller.run_game_engine(lcd, gamepad);
}

void Menu::display_controls(N5110 &lcd, Gamepad &gamepad) {
  // Print lines for aesthetics, and print controls text.
  lcd.drawLine(0,0,84,0,FILL_BLACK);
  lcd.drawLine(0,6,84,6,FILL_BLACK);
  lcd.drawLine(0,24,84,24,FILL_BLACK);
  lcd.drawLine(0,30,84,30,FILL_BLACK);
  lcd.printString("JOYSTICK:",0,0);
  lcd.printString("-Go Left/Right",0,1);
  lcd.printString("-Down to Duck",0,2);
  lcd.printString("Collect Coins!",0,5);
  lcd.printString("A:",0,3);
  lcd.printString("-Jump",0,4);
  play_tone(gamepad);  // Play the tune.
}

void Menu::display_menu(N5110 &lcd, Gamepad &gamepad) {
  // Print lines and sprite for aesthetics, and print menu text.
  lcd.drawLine(0,0,84,0,FILL_BLACK);
  lcd.drawLine(0,6,84,6,FILL_BLACK);
  lcd.drawLine(0,24,84,24,FILL_BLACK);
  lcd.printString("SKATER",24,0);
  lcd.printString("START- Play!",0,1);   
  lcd.printString("X- Controls",0,2); 
  lcd.drawSprite(1,25,23,80,(int*)menu_sprite); 
  play_tone(gamepad);  // Play the tune.
}

void Menu::play_tone(Gamepad &gamepad) {
  // Plays a musical tune in 3/4 based on two chords, A and F in Aminor.
  // It switches between each chord every 12 game loops via chord counter.  
  _tone_flag = !_tone_flag;
  _tone_counter++;
  _chord_counter++;
  if (_chord_counter < 12) {
    play_chord_a(gamepad);
  } else {
    if (_chord_counter == 24) _chord_counter = 0;
    play_chord_b(gamepad);
  }  
  wait(0.14);  // Determines how fast the musical tune is played.
}

void Menu::play_chord_a(Gamepad &gamepad) {
  // For each chord, the first set of two notes is played for 5 game loops and 
  // the second set for 2 game loops via tone counter.
  // Each note is alternated every game loop via tone flag.  
  if (_tone_counter < 5) {
    if (_tone_flag) {
      gamepad.tone(220, 0.5);
    } else {
      gamepad.tone(440, 0.1);
    }
  } else {
    if (_tone_counter == 6) _tone_counter = 0;
    if (_tone_flag) {
      gamepad.tone(174.61, 0.1);
    } else {
      gamepad.tone(246.94, 0.1);
    }
  }
} 

void Menu::play_chord_b(Gamepad &gamepad) {
  // Same as play_chord_a, just different notes. 
  if (_tone_counter < 5) {
    if (_tone_flag) {
      gamepad.tone(174.61, 0.5);  
    } else {
      gamepad.tone(349.23, 0.1);
    }
  } else {
    if (_tone_counter == 6) _tone_counter = 0;
    if (_tone_flag) {
      gamepad.tone(659.25, 0.1);
    } else {
      gamepad.tone(220, 0.1);
    }
  }
} 