#include "Fire.h"

// Define sprite arrays.
int fire_one[5][8] = {
  { 1,0,1,0,0,1,0,0 },
  { 1,0,0,0,1,1,1,0 },
  { 0,0,0,1,1,1,1,1 },
  { 0,1,0,0,1,1,1,0 },
  { 1,0,0,1,0,1,0,0 },
};

int fire_two[5][8] = {
  { 0,0,1,0,0,1,0,0 },
  { 0,1,0,0,1,1,1,0 },
  { 1,0,1,0,1,1,1,0 },
  { 1,0,0,0,1,1,1,0 },
  { 0,1,0,1,1,0,0,0 },
};

// Constructor and destructor.
Fire::Fire() {} 

Fire::~Fire() {}

void Fire::init() {
  // Starting position of the fire (Y coord is calculated externally).
  _x = -10;  // Start fire off screen.
  _fire_counter = false;
}

void Fire::generate_fire() {
  // Sets the X coord so it moves independently.
  _x++;  // Keep fire moving from L to R.
  _fire_counter = !_fire_counter;  // Toggle fire counter to generate different 
  // sprites each iteration.
  if (_x == 90) _x = -10;  // If the fire goes off the screen, restart it on the 
  // other side.
}

int * Fire::get_fire_sprite() {
  // Return different fire sprites for dynamic effect.
  if (_fire_counter) {
    return *fire_one;
  } else {
    return *fire_two;
  }
}
  
int Fire::get_fire_x() {
  return _x;
}





