#ifndef COIN_H
#define COIN_H

#include "mbed.h"

/** Coin Class
* @brief Generates a coin for the skateboarder to collect *@author Lewis Wooltorton
* @date April 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Coin.h"
#include <cstdlib>
#include <ctime>

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Coin _coin;

int _skater_x;
int _skater_y;
int _player_score;
bool _coin_collision_flag;

int main() {
  _coin.init();
  srand(time(NULL));
  _player_score = 0;
  _skater_x = 50;
  _skater_y = 20;
  while(1) {
    
    // If the skater collides with the coin, set the flag, add 1 to the score 
    // move the coin to a new random position and make a noise on the buzzer.
    if (_skater_x == _coin.get_coin_x() 
      && (_skater_y == _coin.get_coin_y() - 10)) {  
    _coin_collision_flag = true;
    _player_score++;
    _coin.set_coin((rand() % 100),(abs(rand() % 100 - 20)));  // Place coin 
    // on a constrained random position.
    gamepad.tone(1500, 0.05);  // Make collection noise on buzzer.
    wait(0.05);
    gamepad.tone(3000, 0.05);   
    }
    
    // Print the coin.
    lcd.drawSprite(_coin.get_coin_x(),_coin.get_coin_y(),5,5,
                   (int*)_coin.get_coin_sprite());
  }
}
       
@endcode
*/

class Coin {
 public:
  // Constructor and Destructor.
  /**
  * @brief Constructor @details Non user specified.
  */
  Coin();
  /**
  * @brief Destructor @details Non user specified.
  */
  ~Coin();
  
  // Mutators.
  /** 
  * @breif Initialises Coin object. 
  */
  void init();
  /**
  * @breif Sets the Coin coordinates.
  * @param rand_x @details a random number that determines the x coordinate
  * @param rand_y @details a random number that determines if the Coin is generated on the upper or lower platforms
  */
  void set_coin(int rand_x, int rand_y);
  
  // Accessors.
  /**
  * @breif Gets the Coin sprite.
  * @returns The Coin sprite (an integer array)
  */
  int * get_coin_sprite();
  /**
  * @breif Gets the x coordinate.
  * @returns The x coordinate of the Coin
  */ 
  int get_coin_x();
  /**
  * @breif Gets the y coordinate.
  * @returns The y coordinate of the Coin
  */
  int get_coin_y(); 
  
  // Member Methods.
  /**
  * @breif Generates the coin. @details Selects the coin sprite
  */
  void generate_coin();
    
 private:
  int _x;
  int _y;
  int _coin_counter;
  bool _rotate_coin;
};
#endif
