/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering University of Leeds
Name: Lewis Wooltorton
Username: el17lw
Student ID Number: 201122085 Date: March 2019
*/

#include "N5110.h"
#include "Gamepad.h"
#include "mbed.h"
#include "Menu.h"
#include "Tests.h" 

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Menu menu;
Tests test;  // Create a test object if tests are to be done.

void init_game();

int main() {
  init_game();  
  while(1) {
    lcd.setContrast(gamepad.read_pot());  // Contrast is controlled by pot.
    lcd.clear();  
    menu.run(lcd, gamepad);  // Comment this out when running tests.
    // Blelow line is an example of testing sprites. See documentation for 
    // parameters and details.
    //test.run_tests(1,1,Skate_right,20,20,20,10,30,50,5,lcd);          
    lcd.refresh();
    wait(0.01);  
  }     
}  
 
void init_game() {
  test.init(20);  // argument is the vertical height of test platforms.
  gamepad.init();
  menu.init(); 
  lcd.init(); 
  lcd.normalMode();      
  lcd.setBrightness(0.5); 
}