#include "Skateboarder.h"
                                                                                
// Define all sprite arrays.
int skate_right[17][10] =   { 
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,1,1,1,1,1,1,0,0,0 },
  { 0,0,0,1,0,1,1,0,0,0 },
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,1,1,1,1,1,1,1,0,0 },
  { 1,1,0,1,1,0,0,1,1,0 },
  { 1,0,0,1,1,0,0,0,0,0 },
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,0,0,1,0,0,0 },
  { 1,0,0,1,0,0,0,1,0,1 },
  { 0,1,1,1,1,1,1,1,1,0 },
  { 0,0,1,0,0,0,0,1,0,0 },  
};

int skate_left[17][10] =   { 
  { 0,0,0,0,1,1,1,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,0,1,1,1,1,1,1,0 },
  { 0,0,0,1,1,0,1,0,0,0 },
  { 0,0,0,0,1,1,1,0,0,0 },
  { 0,0,0,0,0,1,1,0,0,0 },
  { 0,0,0,0,0,1,1,0,0,0 },
  { 0,1,1,1,1,1,1,1,0,0 },
  { 0,0,0,0,1,1,1,1,1,0 },
  { 0,0,0,0,1,1,0,0,1,0 },
  { 0,0,0,0,1,1,0,0,1,0 },
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,1,0,0,1,0,0,0,0 },
  { 1,1,0,0,0,1,0,0,0,1 },
  { 0,1,1,1,1,1,1,1,1,0 },
  { 0,0,0,1,0,0,0,0,1,0 },    
};

int skate_stand_left[17][10] =   { 
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,0,1,1,1,1,1,1,0 },
  { 0,0,0,1,0,0,1,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,1,1,1,1,0,1,0,0 },
  { 1,1,0,1,1,1,0,1,0,0 },
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,1,1,1,1,0,0,0,0 },
  { 1,0,1,0,0,1,0,0,0,0 },
  { 1,1,0,0,0,1,0,0,0,0 },
  { 0,1,0,0,0,1,0,0,0,0 },
  { 1,0,1,0,0,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,1,0,1,1,1,0,0,0 },  
};

int skate_stand_right[17][10] =   { 
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,0,1,1,1,1,0,0,0,0 },
  { 1,1,1,1,1,1,0,0,0,0 },
  { 0,0,1,0,0,1,0,0,0,0 },
  { 0,0,1,1,1,1,0,0,0,0 },
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,0,1,1,1,1,0,0,0,0 },
  { 0,1,1,1,1,0,1,0,0,0 },
  { 1,0,1,1,1,0,0,1,0,0 },
  { 1,0,1,1,1,0,0,0,0,0 },
  { 0,0,1,1,1,1,1,0,0,0 },
  { 0,0,1,0,0,0,1,0,1,0 },
  { 0,0,1,0,0,0,1,1,0,0 },
  { 0,0,1,0,0,0,1,0,1,0 },
  { 0,0,1,0,0,1,0,0,0,0 },
  { 0,0,1,0,1,0,0,0,0,0 },
  { 0,1,1,1,0,1,0,0,0,0 }, 
};

int skate_duck_right[17][10] =   { 
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,1,1,1,1,1,1,0,0,0 },
  { 0,0,0,1,0,0,1,0,0,0 },
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,1,1,1,1,1,1,0,0 },
  { 0,1,0,1,1,1,1,0,1,1 },
  { 1,0,0,1,1,1,1,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,1,1,0,0,1,1,0,0 },
  { 1,0,1,1,0,0,1,1,0,1 },
  { 0,1,1,1,1,1,1,1,1,0 },
  { 0,0,1,0,0,0,0,1,0,0 }, 
};

int skate_duck_left[17][10] =   {
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,0,1,1,1,1,1,1,0 },
  { 0,0,0,1,0,0,1,0,0,0 },
  { 0,0,0,0,1,1,0,0,0,0 },
  { 0,0,1,1,1,1,1,1,0,0 },
  { 1,1,0,1,1,1,1,0,1,0 },
  { 0,0,0,1,1,1,1,0,0,1 },
  { 0,0,0,1,1,1,1,0,0,0 },
  { 0,0,1,1,0,0,1,1,0,0 },
  { 1,0,1,1,0,0,1,1,0,1 },
  { 0,1,1,1,1,1,1,1,1,0 },
  { 0,0,1,0,0,0,0,1,0,0 },   
};

// Constructor and destructor.
Skateboarder::Skateboarder() {} 

Skateboarder::~Skateboarder() {}

void Skateboarder::set_x_position_and_sprite(
    float joy_x, 
    int moving_counter, 
    Skate_direction direction, 
    float joy_y) {
  // Set up the new x coord and use that to set the sprite.           
  _skate_direction = direction;
  _moving_counter = moving_counter;
  process_x_variables(joy_x);      
  _x = 40 + 0.4*_moving_counter;  // Moving counter is scaled for speed control.
  check_duck(joy_y);  // Needed to overwrite sprite if ducking.
}
    
void Skateboarder::process_x_variables(float joy_x) { 
  if (joy_x > float(0.1)) {  // If skater is moving right.
    _moving_counter = _moving_counter++;  // To be added to current X position.
    _skate_direction = Right;  // skate direction enum keeps track of last
    // direction for not moving situation.
    _sprite_value = Skate_right;
  } else if (joy_x < float(-0.1)) {  // If skater is moving left.
    _moving_counter = _moving_counter--;
    _skate_direction = Left;
    _sprite_value = Skate_left; 
  } else if (_skate_direction == Left) {  // Skater is not moving.
    _sprite_value = Stand_left;
  } else { 
    _sprite_value = Stand_right;
  } 
}
    
void Skateboarder::check_duck(float joy_y) {
  // Re-write Sprite_value with correct direction if the duck condition is met.
  if (joy_y < -0.1 && _skate_direction == Right) {
    _sprite_value = Skate_duck_right;         
  } else if (joy_y < -0.1 && _skate_direction == Left) {
    _sprite_value = Skate_duck_left;        
  }
}
      
void Skateboarder::set_y_position(
    bool jump, 
    int jump_counter, 
    int level_condition, 
    Gamepad &gamepad) {
  _jump_counter = jump_counter;
  _level_condition = level_condition; 
  // Jump condition. Jump from A button must be true and counter less than 35 to
  // limit double jump. 
  if (jump && _jump_counter < 35) {  
    _jump_counter = 40;  // Controls height and fall time.
    gamepad.tone(440, 0.05);  // Buzzer jump sound.
    wait(0.05);
    gamepad.tone(880, 0.05);
  }
  if (_jump_counter !=0) _jump_counter--;  // Keep falling until not jumping.       
  if (_level_condition == 1 && jump){  // If skater is under / on-top of upper 
  // platforms, will jump to / stay on upper platforms.
    _level = 5;
  } else if (_level_condition == 0) {
    _level = 23;
  }
  _y = _level - 0.5*_jump_counter;  // Level offsets Y for approprite platform 
  // and scaled jump counter to control height.      
}

int Skateboarder::get_x_position() {
  return _x;
}

int Skateboarder::get_moving_counter() {
  return _moving_counter;
}
  
int Skateboarder::get_y_position() {
  return _y;
}

int Skateboarder::get_jump_counter() {
  return _jump_counter;
}

Skate_direction Skateboarder::get_direction() {
  return _skate_direction;
}
    
Sprite_value Skateboarder::get_sprite_value() {
  return _sprite_value;
}   

int * Skateboarder::get_sprite(Sprite_value sprite) {
  // Return correct sprite.
  if (sprite == Skate_right) {
    return *skate_right;
  } else if (sprite == Skate_left) {
    return *skate_left;
  } else if (sprite == Stand_left) {
    return *skate_stand_left;
  } else if (sprite == Skate_duck_right) {
    return *skate_duck_right;
  } else if (sprite == Skate_duck_left) {
    return *skate_duck_left;
  } else {
    return *skate_stand_right;
  }
} 

void Skateboarder::fall(bool fall_flag, Gamepad &gamepad) {
  // Falling sequence. 
  _fall_flag = fall_flag;
  _y++;
  gamepad.tone(int(-15.8*_y + 1363), 0.05);  // Linear equation makes decending 
  // frequency sound.
  wait(0.005);  // Control fall time and fall sound speed.
  if (_y == 80) {  // Stop falling when y = 80. 
    _fall_flag = false;
    _reset_flag = true;
  }
}
     
bool Skateboarder::get_fall_flag() {
  return _fall_flag;
}
     
bool Skateboarder::get_reset_flag() {
  return _reset_flag;
}
     
void Skateboarder::set_reset_flag(bool flag) {
  if (flag) {
    _reset_flag = true;
  } else {
    _reset_flag = false;
  }
}
     
     