#ifndef FIRE_H
#define FIRE_H

#include "mbed.h"

/** Fire Class
* @brief Generates a fire ball that will end the game if the skateboarder touches it 
* @author Lewis Wooltorton
* @date April 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Fire.h"
#include <cstdlib>
#include <ctime>

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Fire _fire;

int _skater_y;
int _fire_y;

int main() {
  _fire.init();
  _fire_y = 20;
  while(1) {
    
    // Generates the x coordinate of the fire.
    _fire.generate_fire(); // Generates X coord of fire.
    // Y is calculated from parabolic relation to game counter.
    
    // Check for a collision.
    if (_skater_x == _fire.get_fire_x() 
      && _skater_y > _fire_y - 10 
      && _skater_y < _fire_y + 10
      ) {  // A range of Y coords to make collision 
    // more frequent.
    
    // Print fire.
    lcd.drawSprite(_fire.get_fire_x(),_fire_y,5,8,
                   (int*)_fire.get_fire_sprite());
    }
  }                 
} 

@endcode
*/

class Fire {
 public:
  /** Constructor, non user specified.*/
  Fire();
  /** Destructor, non user specified.*/
  ~Fire();
  
  // Mutators.
  /** Initialises Fire object. */
  void init();

  // Accessors
  /** Gets the sprite.
  * @returns The Fire sprite (an integer array)
  */
  int * get_fire_sprite();
  /** Gets the x coordinate. 
  * @returns The x coordinate of the Fire
  */
  int get_fire_x();
  
  // Member methods.
  /** Generates Fire parameters @details Increments Fire x coordinate and toggles fire sprite.*/
  void generate_fire();

 private:
  int _x;
  bool _fire_counter;
};
#endif