#ifndef ENGINECONTROLLER_H
#define ENGINECONTROLLER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Engine.h"

/** EngineController Class
* @brief Class to interface with the game engine
* @author Lewis Wooltorton
* @date March 2019

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "EngineController.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
EngineController controller;

int main() {
  controller.init();
  while(1) {
    
    // Run the game.
    controller.run_game_engine(lcd, gamepad);  
  }     
}  

@endcode
*/

class EngineController {
 public:
  // Constructor and destructor.
  /**
  * @brief Constructor @details Non user specified.
  */
  EngineController();
  /**
  * @brief Destructor @details Non user specified.
  */
  ~EngineController();
  
  // Mutators
  /**
  * @brief Initialises the Game Engine Controller object.
  */ 
  void init();
  /**
  * @brief Runs the game via controlling the game engine.
  * @param &lcd @details The lcd object from the N5110 class
  * @param &gamepad @details The gamepad object from Gamepad class
  */
  void run_game_engine(N5110 &lcd, Gamepad &gamepad);
  
 private:
  void check_for_start(N5110 &lcd, Gamepad &gamepad);
  void print_intro_text(N5110 &lcd);
  void update_game(N5110 &lcd, Gamepad &gamepad);
  
  Engine _game_engine;
  int _game_counter;
  bool _start_platform_flag;
  int _speed_divider;
  int _player_score;
  bool _change_speed_flag;
   
};
#endif




