#include "Coin.h"

// Define sprite arrays.
int coin_front[5][5] = {
  { 0,0,1,0,0 },
  { 0,1,0,1,0 },
  { 1,0,1,0,1 },
  { 0,1,0,1,0 },
  { 0,0,1,0,0 },
};

int coin_side[5][5] = {
  { 0,0,1,0,0 },
  { 0,0,1,0,0 },
  { 0,0,1,0,0 },
  { 0,0,1,0,0 },
  { 0,0,1,0,0 },
};

// Constructor and destructor.
Coin::Coin() {} 

Coin::~Coin() {}

void Coin::init() {
  // Starting position of the coin.
  _x = 20;
  _y = 33;
  _coin_counter = 0;
}

void Coin::generate_coin() {
  // Toggle the state of the coin every 3 loop iterations. This will be used to  
  // print different coin sprites so it looks like it is rotating.
  if (_coin_counter == 2) {
    _coin_counter = 0;
    _rotate_coin = !_rotate_coin;
  }
  _coin_counter++;      
}

void Coin::set_coin(int rand_x, int rand_y) {
  // Set the coin coords based on input values.
  if (rand_y > 40) {  
    _y = 15;  // Set the coin on the top platforms.
  } else {
    _y = 33;  // Set coin on the bottom platforms.
  }
  _x = rand_x;
  if (_x < 3 || _x > 78) {  // Ensures the coin does not generate off-screen.
    _x = 50;  // Default value if the coin generates off-screen.
  }
}

int * Coin::get_coin_sprite() {
  // Return different coin sprites.
  if (_rotate_coin) {
    return *coin_front;
  } else {
    return *coin_side;
  }
}

int Coin::get_coin_x() {
  return _x;
}

int Coin::get_coin_y() {
  return _y;
} 


