#include "EngineController.h"

// Define sprite array.
int intro_text[12][42] =   { 
  { 1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1 },
  { 1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1 },
  { 1,1,0,0,0,0,0,1,1,0,0,1,1,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,
  0,0,1,1 },
  { 1,1,0,0,0,0,0,1,1,0,1,1,1,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,
  0,0,1,1 },
  { 1,1,0,0,0,0,0,1,1,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,1,
  1,1,1,1 },
  { 1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,
  1,1,1,1 },
  { 1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,
  1,0,0,0 },
  { 0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,1,
  1,0,0,0 },
  { 0,0,0,0,0,1,1,1,1,0,1,1,1,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,
  1,1,0,0 },
  { 0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,
  1,1,0,0 },
  { 1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,0,
  1,1,1,0 },
  { 1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,0,
  1,1,1,1 }
};

// Constructor and destructor.
EngineController::EngineController() {}

EngineController::~EngineController() {}

void EngineController::init() {
  // Statrting values for the controller.
  _game_engine.init();
  _game_counter = 0;
  _speed_divider = 10;
  _start_platform_flag = true;
  _change_speed_flag = false;
}

void EngineController::run_game_engine(N5110 &lcd, Gamepad &gamepad) {
  // The main game loop.
  check_for_start(lcd, gamepad);  // Check to see if it should print starting 
  // text.
  if (_game_counter == 100) _game_counter = 0;
  update_game(lcd, gamepad);
  if (_game_counter % _speed_divider == 0) 
  _game_engine.generate_level(_game_counter);  // Level speed is determined by 
  // speed divider.
  _game_counter++;
  _player_score = _game_engine.get_player_score();
  _speed_divider = int(-0.25*_player_score + 10);  // Speed divider is dependent 
  // on how many coins you have
}

void EngineController::check_for_start(N5110 &lcd, Gamepad &gamepad) {
  // Print the intro text if the game has just started or jump has not been 
  // pressed.
  if (_start_platform_flag) print_intro_text(lcd);
  _game_engine.check_reset(lcd, gamepad);  // Resets the game if skater has 
  // died.
  _start_platform_flag = _game_engine.get_start_platform_flag();  // Returns 
  // false when jump is pressed.
}

void EngineController::print_intro_text(N5110 &lcd) {
  lcd.drawLine(0,17,80,17,FILL_WHITE);
  lcd.drawSprite(40,4,12,42,(int *)intro_text);    
}

void EngineController::update_game(N5110 &lcd, Gamepad &gamepad) {
  // Run the game engine.
  _game_engine.read_input(gamepad);
  _game_engine.set_level_condition();  // Determines if the skater is under 
  // upper platforms.
  _game_engine.process_y(gamepad);
  _game_engine.process_x(_game_counter);
  _game_engine.process_sprite();
  _game_engine.check_coin_collision(gamepad);
  _game_engine.check_fire_collision(gamepad, _game_counter);
  _game_engine.update_lcd(lcd, _game_counter);
}

