// pre-processor directives
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "GameEngine.h"


#define RUNNER_WIDTH 3
#define RUNNER_HEIGHT 10
#define OBSTACLE_WIDTH 2
#define OBSTACLE_HEIGHT 8

// structs
struct UserInput {
    bool j;
    bool ran;
};
// objects
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
GameEngine engine;

// prototypes
void init();
void update_game(UserInput input);
void render();
void welcome();

// functions
int main()
{

    int fps = 14;  // screen refresh rate

    init();     // initialise and display welcome screen
    welcome();  // wait for teh user input
    
    render();  // draw the first frame 
    wait(1.0f/fps);  // wait for one period


    // game loop 
    while (1) {
        engine.read_input(pad); //read user input
        engine.update(pad); //update the game
        render(); //update the display
        wait(1.0f/fps); //game speed
    }
}

// initialises classes and libraries
void init()
{
    // need nitialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game with correct runner and obstacle sizes
    engine.init(RUNNER_WIDTH,RUNNER_HEIGHT,OBSTACLE_WIDTH,OBSTACLE_HEIGHT);

}

// draw frames on the LCD
void render()
{
    // clear screen, update screen and refresh
    lcd.clear();  
    engine.draw(lcd);
    lcd.refresh();
}

// welcome screen
void welcome() {
    
    lcd.printString("   Runner  ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // LEDs keep flashing until user clicks start
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.2);
        pad.leds_off();
        wait(0.2);
    }
 
}