#ifndef RUNNER_H
#define RUNNER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

#define FLOOR 40

/** Runner class
* @brief initialises the runner and tells it how to behave according to user input. Also prints score
* @author Kamil Zabraniak
* @date May,2019
*/
class Runner
{
public:

    /**constructor */
    Runner();
    /**econstructor */
    ~Runner();
    /**initialise runner
    * @param position x which is always fixed (int)
    * @param runner height (int)
    * @param runner width (int)
    */
    void init(int x,int height,int width);
    /**draws runner
    * @param lcd command to draw a circle (N5110)
    */
    void draw(N5110 &lcd);
    /** updates runners position
    @param value of j, which is determined by user input (bool)
    */
    void update(bool j);
    /** increments the current score */
    void add_score();
    /** gets the score
    * @return the value of score (int)
    */
    int get_score();
    /** get the current position of the runner
    * @return p which conatins the values of _x and _y of the runner (Vector2D)
    */
    Vector2D get_pos();

private:

    int _height;
    int _width;
    int _x;
    int _y;
    int _speed;
    int _score;

};
#endif