#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Runner.h"
#include "Obstacle.h"

#define START 20

/** GameEngine class
* @brief main game engine initialises  all objects, reads user input and updates the game and screen
* @author Kamil Zabraniak
* @date May, 2019
*/
class GameEngine
{

public:
    /** constructor */
    GameEngine();
    /** deconstructor */
    ~GameEngine();

    /** initialise runner and obstacle parameters
    * @param runner width (int)
    * @param runner height (int)
    * @param obstacle width (int)
    * @param obstacle height (int)
    */
    void init(int runner_width,int runner_height, int obstacle_width, int obstacle_height);
    
    /** reads user input
    * @param check if button y is pressed (Gamepad)
    */
    void read_input(Gamepad &pad);
    
    /** updates the positions of the obstacle and the runner and updates the score
    * @param check if obstacle has passed the runner (Gamepad)
    * @param check if obstacle has collided with runner (Gamepad)
    */
    void update(Gamepad &pad);
    
    /** renders all objects on screen
    * @param prints scores on screen (N5110)
    * @param draws the runner (N5110)
    * @param draws the obstacle (N5110)
    */
    void draw(N5110 &lcd);
    
private:

    void check_obstacle_collisions(Gamepad &pad);
    void check_pass(Gamepad &pad);
    void print_scores(N5110 &lcd);
    
    Runner _r;
    Obstacle _o1;
     
    int _runner_width;
    int _runner_height;
    int _obstacle_width;
    int _obstacle_height;

    int _rx;
    int _o1y;
    
    bool _j;
    bool _ran;

};

#endif