#include "GameEngine.h"

GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}

void GameEngine::init(int runner_width,int runner_height, int obstacle_width, int obstacle_height)
{
    // initialise the game parameters
    _runner_width = runner_width;
    _runner_height = runner_height;
    
    _obstacle_width = obstacle_width;
    _obstacle_height = obstacle_height;

    // x position on screen - WIDTH is defined in N5110.h
    _rx = START;
    
    _o1y = 32;
   // _o2y = 25;
    
    _r.init(_rx,_runner_height,_runner_width);
    
    _o1.init(_o1y,_obstacle_height,_obstacle_width);
}

void GameEngine::read_input(Gamepad &pad)
{
    _j = pad.check_event(Gamepad::Y_PRESSED);
    _ran = true;
}

void GameEngine::draw(N5110 &lcd)
{
    // draw the elements in the LCD buffer
    lcd.drawLine(0,FLOOR,WIDTH,FLOOR,1);
    
     print_scores(lcd);
    
    _r.draw(lcd);
    
    _o1.draw(lcd);
}

void GameEngine::update(Gamepad &pad)
{
    check_pass(pad);
    
    _r.update(_j);
    
    _o1.update(_ran);
    
    check_obstacle_collisions(pad);
    
}

void GameEngine::check_obstacle_collisions(Gamepad &pad)
{
    Vector2D o1_pos = _o1.get_pos();
    
    Vector2D r_pos = _r.get_pos();

    // see if obstacle has hit the runner by checking for overlaps
    if (
        (o1_pos.y >= r_pos.y) && //top
        (o1_pos.y <= r_pos.y + _runner_height) && //bottom
        (o1_pos.x >= _rx) && //left
        (o1_pos.x <= _rx + _runner_width)  //right
    ) {
        pad.tone(1200.0,1.0); // audio feedback
        while(1) {
            pad.leds_on();
            }
    }


}

void GameEngine::check_pass(Gamepad &pad)
{
    Vector2D o1_pos = _o1.get_pos();
    if (o1_pos.x == START - 5) {
        _r.add_score();
        pad.tone(1500.0,0.3); 
    }

}

void GameEngine::print_scores(N5110 &lcd)
{
    // get score
    int r_score = _r.get_score();

    // print to LCD
    char buffer1[14];
    sprintf(buffer1,"%2d",r_score);
    lcd.printString(buffer1,WIDTH/2 - 20,1);  // font is 8 wide, so leave 4 pixel gape from middle assuming two digits
    
} 