#ifndef OBSTACLE_H
#define OBSTACLE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Obstacle class
* @brief initialises the obstacle and tells it how to behave
* @author Kamil Zabraniak
* @date May,2019
*/
class Obstacle
{
public:

    /** constructor */
    Obstacle();
    /** deconstructor */
    ~Obstacle();
    /**initialise obstacle
    * @param position y which is always fixed (int)
    * @param obstacle height (int)
    * @param obstacle width (int)
    */
    void init(int y,int height,int width);
    /** renders the obstacle on the lcd
    * @param lcd command to draw a rectangle (N5110)
    */
    void draw(N5110 &lcd);
    /** update the obstacle's position
    * @param value of ran which is currently set to always true (bool)
    */
    void update(bool ran);
    /** gets the current position of the obstacle
    * @param return p which contain the values of _x and _y of the obstacle (Vector2D)
    */
    Vector2D get_pos();

private:

    int _height;
    int _width;
    int _x;
    int _y;
    int _speed;

};
#endif