/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Ellis Blackford Stroud
Username: el17ebs
Student ID Number: 201155309
Date: 09/05/19
*/
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "SDFileSystem.h"
#include "Menu.h"
#include "GolfEngine.h"

// objects 
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
Gamepad pad;
Menu menu;
GolfEngine golf;
Ticker ticker_frame;

//prototypes
void frame_isr();
void init();


//global variables
volatile int g_frame_flag = 0; //flag set in isr to control running frame rate of game

//functions 
int main()
{
    init(); //Initialises pad, lcd and menu objects. Sets up ticker
    menu.welcome_loop(pad, lcd); //Prints welcome screen and loops until start pressed
    while(1) {   
        //Menu Loop - Naviagates series of loops for menu screens
        if(menu.get_start_game_flag() == false) { //if start flag false stay in menu loop
            menu.menu_loop(pad, lcd); //main menu screen - loops until user chooses next screen 
                switch (menu.get_screen()) { //uses user choice to enter next loop in menu
                    case START:
                        menu.start_loop(pad, lcd); //loops until A pressed then game begins
                        break;
                    case HIGHSCORES:
                        menu.highscores_loop(pad, lcd, sd); //loops until back pressed then returns to main menu screen
                        break;
                    case SETTINGS:
                        menu.settings_loop(pad, lcd); //loops until back pressed then returns to main menu screen
                        break;
                } //when user exits sub-menu loop check game_start_flag - if false then return to main menu loop
        } else { //Game Loop - If start flag = true
            

            menu.reset_start_game_flag(); //resets start flag to return to menu after course complete 
            golf.init(menu.get_frame_rate()); //initialises golf objects, sets variables for game and sets frame rate
            ticker_frame.attach(&frame_isr,1.0f/menu.get_frame_rate()); //sets up ticker used to control running speed/frame rate
            lcd.clear();
            golf.printLevel(lcd);  //Indicating start of game
            lcd.refresh();
            wait(3.0f); 
            golf.reset_game_over_flag();

            while(golf.get_game_over_flag() == false){ //Main Game Loop - When game is over returns to start at menu screen
            
                if(g_frame_flag) { //If ticker calls isr and game not over
        
                    g_frame_flag = 0; //reset flag
                    lcd.clear(); //clears lcd buffer
                    golf.read_input(pad); //reads input from gamepad
                    golf.update_ball(pad, lcd); //moves ball and checks for bounces/shots/holes/game over
                    golf.drawGame(lcd); //draws ball, walls etc. - draws game from previous frame 
                    golf.check_end_level(lcd, pad, sd); //checks if level comleted and if game over
                    lcd.refresh(); //updates lcd display
                    sleep(); //sleeps mcu until ticker wakes it up
                }
            }   
        }
    }
}

void frame_isr() //called by ticker at rate of frame rate 
{
    g_frame_flag = 1;   // set flag in ISR
}

void init() //initialises lcd and pad peripherals
{ 
    lcd.init();
    pad.init();
    menu.init();
    lcd.setContrast(0.55f); //can alter this in settings
    lcd.setBrightness(1.0f); //can alter this in settings

}