#include "GolfEngine.h"

// constructor

GolfEngine::GolfEngine()
{

}

//deconstructor

GolfEngine::~GolfEngine()
{

}

//public methods

void GolfEngine::init(int frame_rate)
{
    _level = 0; //first level 
    _ball.set_total_shot_count(0); 
    _ball.init(levels[_level].ball); //initialises ball in start position for first level
    _ball.set_frame_rate(frame_rate); //sets frame rate for game 
    
}

void GolfEngine::drawGame(N5110 &lcd) //draws ball, hole, walls, power bar, aim help and shot count into lcd buffer
{
    drawHole(lcd, levels[_level].hole); //draws hole for current level using information from levels struct
    _ball.drawBall(lcd); //draws ball
    _ball.drawPower(lcd, _mag); //draws power bar
    _ball.drawAim(lcd, _joy_coord, _angle); //draws aim 
    _ball.printShotCount(lcd); //prints shot count
    drawCourseWalls(lcd,levels[_level].walls,levels[_level].wall_count); //draws walls for current level using information from levels struct 
}

void GolfEngine::read_input(Gamepad &pad) //reads input from gamepad 
{   
    _joy_coord = pad.get_mapped_coord(); //reads joystick coordinates and stores in private variable
    _mag = pad.get_mag();  //reads joystick magnitude and stores in private variable
    _angle = pad.get_angle(); //reads joystick angle and stores in private variable
}

void GolfEngine::update_ball(Gamepad &pad, N5110 &lcd) //updates game using gamepad input 
{
    _ball.check_shoot_ball(pad, _joy_coord);  //checks if user has shot ball and changes velocity accordingly
    _ball.check_wall_bounce(levels[_level].walls, levels[_level].wall_count); //checks if ball has met any bounce conditions and bouces accordingly
    _ball.move_ball();  //moves ball dependant on velocity and frame rate   //bounce check uses WallType array term of Levels struct to check bounces for each wall
    if(_ball.get_bounce_flag()) { //set when ball bounces causes buzzer to beep
        _ball.reset_bounce_flag(); //set bounce flag to flse
        pad.tone(523.25, 0.1); //play note when bounce (middle C)
    }
}

void GolfEngine::check_end_level(N5110 &lcd, Gamepad &pad, SDFileSystem &sd)
{
    if(_ball.check_hole(levels[_level].hole) == true) { //End of level sequence when level completed

        drawCourseWalls(lcd,levels[_level].walls,levels[_level].wall_count); //draw walls for flash animation
        _level++; //increment level counter
        g_maj7_flash(pad, lcd); //flashes screen with g maj chord
        g_maj7_flash(pad, lcd);
        lcd.clear();
        lcd.refresh();
        c_maj(pad); //c major chord
        new_level(lcd, sd); //checks if all level completes, initialises new level or end level sequence
        lcd.refresh();
        wait(2);
    }    
}

void GolfEngine::printLevel(N5110 &lcd) //prints current level
{
    char buffer[14]; //temporary buffer to store chars in
    sprintf(buffer,"Level %i",_level+1); //creates string 
    lcd.printString(buffer,24,2);  //prints string to lcd
}

void GolfEngine::reset_game_over_flag() //sets game over flag to false
{
    _game_over_flag = false;   
}

bool GolfEngine::get_game_over_flag() //returns game over flag
{
    return _game_over_flag;
}

//private methods

void GolfEngine::drawCourseWalls(N5110 &lcd, const WallMap map[], int size) //walls for current level
{    
    for(int i = 0; i < size; i++){ //runs through array of WallMap structs and draws the walls
        lcd.drawLine(map[i].start.x,map[i].start.y,map[i].end.x,map[i].end.y,1);
    }
}   

void GolfEngine::drawHole(N5110 &lcd, Coord hole) //draws hole for current level
{
    lcd.drawRect(hole.x,hole.y,3,3,FILL_TRANSPARENT); //draws hole at coordinate 
}

void GolfEngine::file_append(int value, SDFileSystem &sd) //appeneds value to highscores.txt file in micro sd
{
    FILE *fp;
    fp = fopen("/sd/highscores.txt", "a"); //attempts to open highscores.txt
    if (fp == NULL) {  // if file does not exist then create new highscores.txt file
         printf("Error! Unable to open file!\n"); //print error message
    } else {
        fprintf(fp, "\n%i", value); //appends total shot count to highscores file
        fclose(fp);  //close file
    } 
}

void GolfEngine::new_level(N5110 &lcd, SDFileSystem &sd) //called after ball is enters hole 
{ 
    if(_level < 7) { //if all levels are completed
        printLevel(lcd);
        _ball.init(levels[_level].ball); //initialises ball in position for new level
    } else if (_level >= 7) { //if all levels not completed 
    
        _ball.init(levels[_level].ball); //to add the last levels shot count to the toal tally - ball position irrelevant
        lcd.printString("COURSE ",26,2);  
        lcd.printString("COMPLETE",22,3);  
        lcd.refresh();
        wait(3);
        lcd.clear();
        char buffer[14];
        sprintf(buffer," %i",_ball.get_total_shot_count()); 
        lcd.printString("YOUR SCORE:",14,1);  
        lcd.printString(buffer,30,3); //print final score 
        lcd.refresh();
        wait(5);   
        file_append(_ball.get_total_shot_count(), sd); //appends final score to highscores.txt file
        _game_over_flag = true;
    }
}

void GolfEngine::c_maj(Gamepad &pad) //Buzzer plays C chord descending with flashing leds
{
    pad.leds_on();
    pad.tone(1567.98, 0.25); //play note (G6)
    wait(0.25);
    pad.leds_off();
    pad.tone(1046.50, 0.25); //play note C6)
    wait(0.25);
    pad.leds_on();
    pad.tone(783.99, 0.25); //play note (G5)
    wait(0.25);
    pad.leds_off();
    pad.tone(659.25, 0.25); //play note (E5)
    wait(0.25);
    pad.leds_on();
    pad.tone(523.25, 0.25); //play note (C5)
    wait(0.25);
    pad.leds_off();
}

void GolfEngine::g_maj7_flash(Gamepad &pad, N5110 &lcd) // Screen inverse flashing and buzzer plays G7 Chord with leds on
{ 
    pad.leds_on();
    lcd.inverseMode(); //pixels on = off & off = on
    lcd.refresh();
    pad.tone(783.99, 0.25); //play note (G5)
    wait(0.25);
    lcd.normalMode(); 
    lcd.refresh();
    pad.tone(987.77, 0.25); //play note (B5)
    wait(0.25);
    lcd.inverseMode();
    lcd.refresh();
    pad.tone(1174.66, 0.25); //play note D6) 
    wait(0.25);
    lcd.normalMode();
    lcd.refresh();
    pad.tone(1396.91, 0.25); //play note F6)
    wait(0.25);
}

