#include "main.h"
#include "menu.h"
#include "tutorial.h"
#include "constants.h"
#include "models.h"
#include "gameobject.h"

Tutorial::Tutorial() {                              
    current_page = 0;                     
}                                          

GameObject arrowLeft;
GameObject arrowRight;
GameObject smallStar;
GameObject mediumStar;

/**@brief
  * This function just displays some strings of the dysplaye to tell the player
  * how to use the controls and what to do.
  */
bool Tutorial::updateAndWriteTutorial(){
    turnPages();
    drawArrowsAndExitButton();
    
    if (current_page == 0){ tutorialPage0();}
    else if (current_page == 1){ tutorialPage1();}
    else if (current_page == 2){ tutorialPage2();}
    else if (current_page == 3){ tutorialPage3();}
    else if (current_page == 4){ tutorialPage4();}
    else if (current_page == 5){ tutorialPage5();}
    else if (current_page == 6){ tutorialPage6();}
    else if (current_page == 7){ tutorialPage7();}
    else if (current_page == 8){ tutorialPage8();}
    else if (current_page == 9){ tutorialPage9();}
    else if (current_page == 10){ tutorialPage10();}
    else if (current_page == 11){ tutorialPage11();}
    
    bool back_to_menu = false;    
    if (gamepad.check_event(gamepad.B_PRESSED)){
        gamepad.check_event(gamepad.B_PRESSED);
        gamepad.check_event(gamepad.A_PRESSED);
        back_to_menu = true; 
    }
    return back_to_menu;   
}

void Tutorial::drawArrowsAndExitButton(){
    char buffer[16];
    sprintf(buffer,"page #%i", current_page);
    lcd.printString(buffer,20,0);
    
    arrowLeft.pos.x = left_arrow_pos_x;
    arrowLeft.pos.y = arrows_pos_y;
    arrowRight.pos.x = right_arrow_pos_x;
    arrowRight.pos.y = arrows_pos_y;
    smallStar.pos.x = 10;
    smallStar.pos.y = 10;
    mediumStar.pos.x = 10;
    mediumStar.pos.y = 15;
  
    drawSprite(arrowRight.pos, tutorial_arrow_right_sprite);
    drawSprite(arrowLeft.pos, tutorial_arrow_left_sprite);
    lcd.printString("Push B to Exit",0,5);
}

void Tutorial::turnPages(){
     if(x_dir.read() > joy_threshold_max_x){
        current_page -= 1;
        wait_ms(time_delay);    
    } 
    else if (x_dir.read() < joy_threshold_min_x){
        current_page += 1;
        wait_ms(time_delay); 
    }
    if (current_page < 0) {
        current_page += total_pages;
    }
    if (current_page >= total_pages) {
        current_page -= total_pages;
    }  
}

void Tutorial::tutorialPage0(){
    lcd.printString("X - shoot",0,1);
    lcd.printString("START - Pause",0,2);
    lcd.printString("JOYSTICK - is ",0,3);
    lcd.printString("ship movement",0,4);
}

void Tutorial::tutorialPage1(){
    lcd.printString("Shield is ",0,1);
    lcd.printString("Activaed/ ",0,2);
    lcd.printString("Deactivated by",0,3);
    lcd.printString("R button ",0,4);
}

void Tutorial::tutorialPage2(){
    lcd.printString("Shield only",0,1);
    lcd.printString("blocks blasts.",0,2);
    lcd.printString("Doesn't block",0,3);
    lcd.printString("enemy clash",0,4);
}

void Tutorial::tutorialPage3(){
    lcd.printString("When shield",0,1);
    lcd.printString("is ON, shooitg",0,2);
    lcd.printString("is deactivated",0,3);
}

void Tutorial::tutorialPage4(){
    lcd.printString("You have to",0,1);
    lcd.printString("switch between",0,2);
    lcd.printString("offence and",0,3);
    lcd.printString("deffence",0,4);
}

void Tutorial::tutorialPage5(){
    lcd.printString("Evade or block",0,1);
    lcd.printString("enemy shots",0,2);
    lcd.printString("and don't let ",0,3);
    lcd.printString("them pass.",0,4);
}

void Tutorial::tutorialPage6(){
    lcd.printString("Your health is",0,1);
    lcd.printString("shown below",0,2);
    lcd.printString("the screen ",0,3);
    lcd.printString("It's LEDs. ",0,4);
}

void Tutorial::tutorialPage7(){
    lcd.printString("Kill the ",5,2);
    lcd.printString("Enemies!!! ",10,3);
}

void Tutorial::tutorialPage8(){
    lcd.printString("foe died= 30",0,1);
    lcd.printString("miss shot= -10",0,2);
    lcd.printString("foe left= -50",0,3);
    lcd.printString("Be careful ",10,4);
}

void Tutorial::tutorialPage9(){
    lcd.printString("As your score",0,1);
    lcd.printString("increase, so ",0,2);
    lcd.printString("does the game ",0,3);
    lcd.printString("difficulty ",10,4);
}

void Tutorial::tutorialPage10(){
    drawSprite(smallStar.pos, small_star_sprite);
    drawSprite(mediumStar.pos, medium_star_sprite);
    lcd.printString("S Star",20,1);
    lcd.printString("M Star ",20,2);
    lcd.printString("They do not  ",0,3);
    lcd.printString("hurt you ",30,4);
}

void Tutorial::tutorialPage11(){
    lcd.printString("Good Luck!!! ",0,3);
}

