#include "main.h"
#include "menu.h"
#include "constants.h"
#include "settings.h"
#include "gameobject.h"
#include "models.h"


Settings::Settings() {                              
    current_page = 0;                     
}                                          

GameObject settingsArrowLeft;
GameObject settingsArrowRight;

bool Settings::updateAndWriteSettings(){
    if(x_dir.read() > joy_threshold_max_x){
        current_page -= 1;
        wait_ms(time_delay);    
    } else if (x_dir.read() < joy_threshold_min_x){
        current_page += 1;
        wait_ms(time_delay); 
    }
    if (current_page < 0) {
        current_page += total_pages;
    }
    if (current_page >= total_pages) {
        current_page -= total_pages;
    }  
    if (current_page == 0){ settingsPage0();}
    else if (current_page == 1){ settingsPage1();}
    
    drawArrowsAndExitButton();
    lcd.printString("Use the Pot",0,4);
    bool back_to_menu = false; 
    if (gamepad.check_event(gamepad.B_PRESSED)){
        //gamepad.check_event(gamepad.B_PRESSED);
        gamepad.check_event(gamepad.A_PRESSED);
        back_to_menu = true; 
    }
    return back_to_menu;  
}


void Settings::drawArrowsAndExitButton(){
    char buffer[16];
    sprintf(buffer,"page #%i", current_page);
    lcd.printString(buffer,20,0);
    
    settingsArrowLeft.pos.x = 6;
    settingsArrowLeft.pos.y = 0;
    settingsArrowRight.pos.x = 66;
    settingsArrowRight.pos.y = 0;
  
    drawSprite(settingsArrowRight.pos, tutorial_arrow_right_sprite);
    drawSprite(settingsArrowLeft.pos, tutorial_arrow_left_sprite);
    lcd.printString("Push B to Exit",0,5);
}

void Settings::settingsPage0(){
    lcd.setBrightness(pot.read());
    lcd.printString("Set Brightness ",0,1);
    lcd.drawRect(3, 20, 70, 10, FILL_TRANSPARENT);
    lcd.drawRect(3, 20, 70*pot.read(), 10, FILL_BLACK);
}

void Settings::settingsPage1(){
    lcd.setContrast(pot.read());
    lcd.printString("Set Contrast",0,1);
    lcd.drawRect(3, 20, 70, 10, FILL_TRANSPARENT);
    lcd.drawRect(3, 20, 70*pot.read(), 10, FILL_BLACK);
}

