#ifndef MENU_H
#define MENU_H


/**
 * The enumeration of available options in the menu. 
 */
enum ScreenOption {             
    ScreenOption_Menu,      /**< The menu option - Choosing other options */
    ScreenOption_Game,      /**< The game option - To start the game */
    ScreenOption_Tutorial,  /**< The tutorial option - To open tutorial */
    ScreenOption_Settings   /**< The settings option - To open settings */
};

/**
 * Menu Class
 * @brief Describes the menu.
 * @author Dmitrijs Griskovs
 * @date 15/04/2019
 */
class Menu {
public:
    /** A constructor */
    Menu();    
    /** 
     * @brief Updates and Draws menu.
     * @details Updates and draws menu options. Also, allows to select an option availabe   
     * from the enum. It return "true" statment if the user picked a menu option.
     */                            
    bool updateAndDraw();  

    /** Returns currently selected meny option */
    ScreenOption getCurrentScreenSelection(); 
        
private:
    int current_option;
    static const int total_options = 3;
    static const float time_delay = 50;
    void pointerPosition(int menu_number);
    void drawPointer();
    void DrawPressAIcon();
    void checkJoystick();
};


#endif