#include "main.h"
#include "menu.h"
#include "constants.h"
#include "game.h"
#include "hud.h"
#include "models.h"
#include "gameobject.h"
#include "stars.h"

Hud highScore;
GameObject cursor;
GameObject pressASprite;
Stars menuStars;

Menu::Menu() {                              // NOTE to self: The constructor for declerering intial states of variables.
                                            // As soon as Menu menu; happens in main, the zero is addressed to the variable.
    current_option = 0;                     // Another form of declering intial values.
                                            // cheking whether the joystick was moved to point at other options in the menu.             
}                                           
    
bool Menu::updateAndDraw() {                
    checkJoystick();
    drawPointer();                              // Drawing pointer only ones.
    highScore.drawHighScore();
    menuStars.starsSpawnDelay();
    menuStars.updateAndDrawSmallStars();
    menuStars.updateAndDrawMediumStars();
        
    lcd.printString("Start Game",1,2);
    lcd.printString("Tutorial",1,3);
    lcd.printString("Settings",1,4);
    DrawPressAIcon();
        
    bool option_picked = false;                 // Checking for the selecting button to be pressed and returning the boolean statement.
    if (gamepad.check_event(gamepad.A_PRESSED)){
        gamepad.check_event(gamepad.A_PRESSED);
        option_picked = true;
    }
    
    return option_picked;
}

ScreenOption Menu::getCurrentScreenSelection() { // checking the current position of the pointer and main
    if (current_option == 0) {                   // if the "Game" was selected and button be pressed, intilise game. 
        return ScreenOption_Game;                // TASK for future: creat file with settings and tutorial.
    }
    if (current_option == 1) {
        return ScreenOption_Tutorial;
    }
    if (current_option == 2) {
        return ScreenOption_Settings;
    }
    return ScreenOption_Menu;
}

void Menu::drawPointer(){                       // Checking what option was selected and drawing the pointer
                                                // to indicate that postion.
    cursor.pos.x = 70;                            
    cursor.pos.y = 17;       
    if (current_option == 0){    
        cursor.pos.y = 17;
    }
    else if (current_option == 1){    
        cursor.pos.y = 25;
    }
    else if (current_option == 2){    
        cursor.pos.y = 32;
    }
    drawSprite(cursor.pos, menu_cursor_sprite);
}

void Menu::DrawPressAIcon(){
    pressASprite.pos.x = screen_width - PressAWidth - 10;
    pressASprite.pos.y = screen_height - PressAHeight;
    drawSpriteOnTop(pressASprite.pos, Press_A_Icon_Sprite);
}

void Menu::checkJoystick(){
    if(y_dir.read() > joy_threshold_max_y){
        current_option -= 1;
        wait_ms(time_delay);    
    } 
    else if (y_dir.read() < joy_threshold_min_y){
        current_option += 1;
        wait_ms(time_delay); 
    }
    if (current_option < 0) {
        current_option += total_options;
    }
    if (current_option >= total_options) {
        current_option -= total_options;
    }
}
