/**
    ELEC2645 Embedded Systems Project
    School of Electronic & Electrical Engineering
    University of Leeds
    Name: Dmitrijs Griskovs
    Username: el17dg
    Student ID Number: 201160286
    date: start - 25/02/2019
*/

#include "constants.h"

#include "main.h"
#include "game.h"
#include "menu.h"
#include "models.h"
#include "tutorial.h"
#include "gameobject.h"
#include "settings.h"


N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);

AnalogIn pot(PTB2);
AnalogIn x_dir(PTB11);
AnalogIn y_dir(PTB10);
AnalogIn rand_y(PTB3);

Menu menu;
Game game;
Tutorial tutorial;
Settings settings;
Gamepad gamepad;

GameObject lineOne;
GameObject lineOneStars;
GameObject lineTwo;
GameObject lineTwoShips;
GameObject lineThree;

void setupIntroValues();
void updateAndDrawIntroPartOne();
void updateAndDrawIntroPartTwo();
void introMusic(int low_frequency_music_counter);
void introPartOneText();
void intro();
void createdByIntro();
void noteToPlayer();
void menuSelection();

ScreenOption current_screen = ScreenOption_Menu;

int main(){
    lcd.init();
    gamepad.init();
    DG_PRINTF("Intro starts\n");
    intro();
    createdByIntro();
    noteToPlayer();
    //Makeing the generated y position for the enemy to be trully random.
    srand(rand_y * 1000000);
    gamepad.check_event(gamepad.A_PRESSED);                            
    while(1){                                         
        lcd.clear();
        menuSelection();
        lcd.refresh();
        wait_ms(1000/fps);
    }
}

void intro(){
    int start_game_text_counter = 0;
    setupIntroValues();
    updateAndDrawIntroPartOne();
    updateAndDrawIntroPartTwo();
    wait(1);
    //Stop just a few pixels above the bottom screen border.
    while (!gamepad.check_event(gamepad.START_PRESSED)){
        lcd.clear();
        introPartOneText();
        if (start_game_text_counter >= 2){
            lcd.printString("Press START",10,5);
            if (start_game_text_counter == 4){
                start_game_text_counter = 0;
            }  
        }
        start_game_text_counter += 1;
        lcd.refresh();          
    }
}

void setupIntroValues(){
    lineOne.pos.x = -63;                                         // The width of the sprite.    
    lineOne.pos.y = 1;                                           // This just will be an intro for the game.//////////////////
    lineOneStars.pos.x = screen_width;
    lineOneStars.pos.y = 1;
    
    lineTwo.pos.y = 15;
    lineTwo.pos.x = screen_width;
    lineTwoShips.pos.x = -46;                 // Starting position outside the screen limits, with the length of the sprite.
    lineTwoShips.pos.y = 14;                  // the height of the "The last One" and a few pixels for gaps. 
    
    lineThree.pos.x = 2;
    lineThree.pos.y = screen_height;          // Starting outside the screen limits on the botto - the screen's height + the sprite's height.
}    

void updateAndDrawIntroPartOne(){
    // the width of the line one + 2.
    for (int i = 0; i < 65; i++){           
        lcd.clear();
        lineOne.pos.x +=1;
        if (lineOneStars.pos.x > 70){ lineOneStars.pos.x  -= 1; }
        // to stop moving at the position of its width.
        if (lineTwo.pos.x > screen_width - 30){ lineTwo.pos.x -=1; }
        if (lineTwoShips.pos.x < 0){ lineTwoShips.pos.x += 1; }
        
        introPartOneText();
        gamepad.tone(200,2);
        
        lcd.refresh();
        wait(0.01);
    }
}

void updateAndDrawIntroPartTwo(){
    int low_frequency_music_counter = 0;
    for (int i = 0; i < 19 + 3; i++){
        lcd.clear();
        lineThree.pos.y -= 1;
        introPartOneText();
        drawSprite(lineThree.pos, intro_line_three_sprite);
        lcd.refresh();
        wait(0.1);
        introMusic(low_frequency_music_counter);
        low_frequency_music_counter++;
    } 
}
/**@brief
    * I have put the upper part of the intro into a separate function because it
    * it is being called several times in this file
    */
void introPartOneText(){
    drawSprite(lineOne.pos, intro_line_one_sprite);
    drawSprite(lineOneStars.pos, intro_line_one_stars_sprite);
    drawSprite(lineTwo.pos, intro_line_two_sprite);
    drawSprite(lineTwoShips.pos, intro_line_two_ships_sprite); 
}

void menuSelection(){
    if (current_screen == ScreenOption_Game) {
        bool game_is_paused = game.updateAndDraw();
        if (game_is_paused) { current_screen = ScreenOption_Menu;}
        
    } if (current_screen == ScreenOption_Tutorial) {
        bool back_to_menu = tutorial.updateAndWriteTutorial();  
        if (back_to_menu) {
            current_screen = ScreenOption_Menu;
        }
    } if (current_screen == ScreenOption_Settings) {
        bool back_to_menu = settings.updateAndWriteSettings();
        if (back_to_menu) {
            current_screen = ScreenOption_Menu;
        }
    } else if (current_screen == ScreenOption_Menu) {
        bool wantsToChangeScreen = menu.updateAndDraw();
        if (wantsToChangeScreen) {
            current_screen = menu.getCurrentScreenSelection();
        }
    }
}

void introMusic(int low_frequency_music_counter){   
    if (low_frequency_music_counter == 0){ gamepad.tone(90,2);}
    else if (low_frequency_music_counter == 2){gamepad.tone(60,2);}
    else if (low_frequency_music_counter == 4){gamepad.tone(190,2);}
    else if (low_frequency_music_counter == 6){gamepad.tone(60,2);}
    else if (low_frequency_music_counter == 8){gamepad.tone(90,2);}
    else if (low_frequency_music_counter == 10){gamepad.tone(160,2);}
    else if (low_frequency_music_counter== 12){
        gamepad.tone(90,1);
        low_frequency_music_counter = 0;
    }
}
void createdByIntro(){
    lcd.clear();
    lcd.printString("Created and",0,0);
    lcd.printString("Developed by",0,1);
    lcd.printString("D Griskovs",10,3);
    lcd.printString("el17dg",20,4);
    lcd.printString("201160286",12,5);
    lcd.refresh();
    wait(2);
}

void noteToPlayer(){
    lcd.clear();
    lcd.printString("Please Read",0,0);
    lcd.printString("The TUTORIAL",10,2);
    lcd.printString("First!",30,4);
    lcd.refresh();
    wait(3);
}