#ifndef SPRITE_H
#define SPRITE_H

#include "collision_lib.h"
#include "main.h"

/** @struct Sprite
 * @brief A function to put a sprite and its data in one variable.
 * @details A struct that alows to create an object containing a sprite, its width and height.
 * It is used with another function located in main.h.
 * @var Sprire::width .
 * Member 'width' contains witdh of the sprite.
 * @var Sprire::height.
 * Member 'height' contains height of the sprite.
 * @var Sprire::data.
 * Member 'data' contains the array of 1s and 0s of the sprite.
 */
struct Sprite {
    /*@{*/
    Sprite(int _width, int _height, const int* _data) : width(_width), height(_height), data(_data) {}
    int width; /**< The width of the sprite*/
    int height; /**< The height of the sprite*/
    const int* data;  /**< The array of 1s and 0s of the sprite.*/
};

/** 
 * @brief A simplified function to draw sprites.
 * @details This is a specific function I made to simplify drawing the sprites.
 * It only works with spawn() function in gameobject.h.
 * The parameters for this function are given in the models.cpp for the
 * sprites.
 */
static void drawSprite(Point pos, const Sprite& sprite) {
    lcd.drawSprite(pos.x, pos.y, sprite.height, sprite.width, (int*)sprite.data);
}

/** 
 * @brief A simplified function to draw sprites. But this draw black pixels on top of white pixels.
 * @details This is an exactly the same function as before, but for the drawing
 * sprite function that draws the black pixels on top the white pixels when the 
 * sprites overlap.
 */
static void drawSpriteOnTop(Point pos, const Sprite& sprite) {
    lcd.drawSpriteOnTop(pos.x, pos.y, sprite.height, sprite.width, (int*)sprite.data);
}

#endif