#ifndef HUD_H
#define HUD_H

/**
 * Hud Class
 * @brief Renders interface elemets such as score and lifes
 * @author Dmitrijs Griskovs
 * @date 15/04/2019
 */
class Hud {

public:
     /** 
     * Constructor. 
     * @brief calls for the reset of red LED. 
     */ 
    Hud() { resetRedLed(); }
    
    /** @brief Resets red LED state and counter. */
    void resetRedLed() {
        red_led_flashing = 0;
        red_led_state = false;
    }
    
    /** @brief Draws an in-game score on the screen during the gameplay. */
    void drawScore(){
        char buffer[16];
        sprintf(buffer," Score: %i", GameGlobals::game_score);
        lcd.printString(buffer,0,0);    
    }
    
    /**@brief Displays in the main menu the highest score reached. */
    void drawHighScore(){
        char buffer[16];
        sprintf(buffer,"HS: %i", GameGlobals::high_score);
        lcd.printString(buffer,0,0);
    }
     
    /** 
     * @brief Display life counter using LEDs.
     * @details Checks the palyer's life value and lights the LEDs on/off 
     * accordingly to how many lifes are left. green = 3, yellow = 2 and red = 1.
     */
    void displayLifes(){
        if (GameGlobals::player_lifes == 3){
            playerHasThreeLives();  
        }
        else if (GameGlobals::player_lifes == 2){
            playerHasTwoLives();
        }
        else if (GameGlobals::player_lifes == 1){
            playerHasOneLife();
        }
        else {
            // all LEDs are flashing
            gamepad.leds_off();
        }        
    }
   
private:
    void playerHasThreeLives(){
        //turn all LEDs on
        gamepad.leds_on();   
    }
    
    void playerHasTwoLives(){
      // only yelow and red are lit (total 4)
        gamepad.led(6,0.0);
        gamepad.led(3,0.0);
    }
    
    void playerHasOneLife(){
        // red LED is lit and flashes.
        gamepad.led(2,0.0);
        gamepad.led(5,0.0);
        gamepad.led(6,0.0);
        if (red_led_flashing == 5){
            gamepad.led(1,(float)red_led_state);
            gamepad.led(4,(float)red_led_state);
            gamepad.led(1,(float)!red_led_state);
            gamepad.led(4,(float)!red_led_state);
            red_led_flashing = 0;
            red_led_state = !red_led_state;
        }        
        red_led_flashing += 1;
    }
    
    int red_led_flashing;
    bool red_led_state;
};

#endif