#ifndef GAMEOVERMANAGER_H
#define GAMEOVERMANAGER_H

/** 
 * GameOverManager Class
 * @brief A class for updating and drawing GameOver state.
 * @author Dmitrijs Griskovs
 * @date 30/04/2019
 */
class GameOverManager {
public:
    /** 
     * Constructor. 
     * @brief It init the GameOver with reseting 
     * the statrting sequence of the gameOver state.
     */ 
    GameOverManager() { reset(); }
    
    /** 
     * @brief Resets the gameOver to the animiation to appear again
     * @returns bool started, when GameOver begins.
     */
    void reset() { started = false; }
    /** 
     * @brief Updates and draws the game over animation.
     * @details It draws "GameOver" sprite from the leftside of the screen to the center
     * and "youDied" sprite from the right side to the center.  
     */
    void updateAndDraw() {
        if (!started) { startAnimation();}
        if (animation_counter < animation_length) {
            if (gamepad.check_event(gamepad.START_PRESSED)) {
                gameOverLogo.pos.x = game_area_x - 29 + 42;
                youDied.pos.x = game_area_width - 42;
                animation_counter = animation_length;
            } else {
                animation_counter++;
                gameOverLogo.pos.x += 1;
                youDied.pos.x -= 1;
            }
        }            
        drawSprite(gameOverLogo.pos, game_over_sprite);
        drawSprite(youDied.pos, you_died_sprite);
        gameOverPostAnimation();
        musicGameOver();
        ledsGameOver();   
    }
    
    /** 
     * @brief Checks for whether the animation of GameOver has stoped drawing or not
     * @details It check the value of the counter against the total length of the
     * animation play. When the counter equals to the total length, it indicates that
     * the animation has stopped  
     */
    bool isPlayingAnimation() {
        return animation_counter < animation_length;
    };

private:
    void startAnimation() {
        started = true;
        gameOverLogo.pos.x = game_area_x - 29; // 0 - the sprite length
        gameOverLogo.pos.y = game_area_y;
        youDied.pos.x = game_area_width; 
        youDied.pos.y = game_area_y;
        animation_counter = 0;
        led_state = false;
        low_frequency_music_counter = 0;
        high_frequency_music_counter = 0;
    }

    void ledsGameOver(){
        gamepad.led(1,(float)led_state);
        gamepad.led(2,(float)!led_state);
        gamepad.led(3,(float)led_state);
        gamepad.led(4,(float)!led_state);
        gamepad.led(5,(float)led_state);
        gamepad.led(6,(float)!led_state);
        led_state = !led_state;   
    }

    void musicGameOver(){
        lowFrequencyPartMusic();
        highFrequencyPartMusic();
        high_frequency_music_counter++;
        low_frequency_music_counter++;//comment out this for epic game over beat.
        DG_PRINTF("Low frequency counter value:: %i\n", low_frequency_music_counter);
        DG_PRINTF("high frequency counter value:: %i\n", high_frequency_music_counter);
    }
    
    void lowFrequencyPartMusic(){
        // Low frequency
        if (low_frequency_music_counter == 0){ gamepad.tone(60,3);}
        else if (low_frequency_music_counter == 3){gamepad.tone(90,3);}
        else if (low_frequency_music_counter == 6){gamepad.tone(60,3);}
        else if (low_frequency_music_counter == 9){gamepad.tone(80,3);}
        else if (low_frequency_music_counter == 12){gamepad.tone(70,2);}
        else if (low_frequency_music_counter == 14){gamepad.tone(60,2);}
        else if (low_frequency_music_counter == 16){gamepad.tone(70,3);}
        else if (low_frequency_music_counter == 19){gamepad.tone(50,1);}
        else if (low_frequency_music_counter == 20){gamepad.tone(40,3);}
        else if (low_frequency_music_counter== 23){
            gamepad.tone(60,2);
            low_frequency_music_counter = 0;
        } 
}

    void highFrequencyPartMusic(){
        // High frequency
        if ( high_frequency_music_counter == 0){ gamepad.tone(300,0.1);}
        else if (high_frequency_music_counter == 3){gamepad.tone(250,0.1);}
        else if (high_frequency_music_counter == 6){gamepad.tone(230,0.2);}
        else if (high_frequency_music_counter == 9){gamepad.tone(250,0.1);}
        else if ( high_frequency_music_counter == 12){gamepad.tone(250,0.2);}
        else if ( high_frequency_music_counter == 14){gamepad.tone(220,0.1);}
        else if ( high_frequency_music_counter == 16){gamepad.tone(210,0.3);}
        else if ( high_frequency_music_counter == 19){gamepad.tone(200,1);}
        else if ( high_frequency_music_counter == 21){gamepad.tone(250,1);}
        else if ( high_frequency_music_counter == 22){
            gamepad.tone(200,1);
            high_frequency_music_counter = 0;
        }
    }
     void updateHighScore(){
        if (GameGlobals::high_score < GameGlobals::game_score){
            GameGlobals::high_score = GameGlobals::game_score;
        }
    }
    
    void gameOverPostAnimation(){
        char buffer[32];
        sprintf(buffer,"Score: %i", GameGlobals::game_score);
        updateHighScore();
        lcd.printString(buffer,0,3);   
        lcd.printString("Press Y",0,4);
        lcd.printString("to restart",0,5);
        gamepad.check_event(gamepad.START_PRESSED);
    }
    
    bool started;
    static const int animation_length = 42;
    int animation_counter;
    GameObject gameOverLogo;
    GameObject youDied;
    bool led_state;
    int low_frequency_music_counter;
    int high_frequency_music_counter;
};

#endif