#ifndef GAME_H
#define GAME_H

/** 
 * GameGlobals Class
 * @brief Globals that different places in code can modify
 * @author Dmitrijs Griskovs
 * @date 22/04/2019
 */
class GameGlobals {
public:
    static int game_score;
    static int score_count_for_difficulty;
    static int score_count_for_boss_mode;
    static int player_lifes;
    static int high_score;
    static bool is_shield_on;
};

/** 
 * Game Class
 * @brief Stores general game logic.
 * @author Dmitrijs Griskovs
 * @date 15/04/2019
 */
class Game{
public:
    /** 
     * Constructor. 
     * @brief It is crucial to init game_state to GameState_newgame, so it calls
     * startNewGame() on the first update. 
     */ 
    Game() : game_state(GameState_newgame) { }
    
    /** 
     * @brief The main game function where all the gameplay and rendering happens.
     * @details This is the main function of game.cpp, where the actual gameplay happens.
     * Here all other functions are activeated, and when the player dies, it
     * returns back to main menu "main.cpp" it also draws all sprites in the game.
     * @returns bool want_to_pause, when "START" button is pressed.
     */
    bool updateAndDraw();

    /**
     * @brief Resets all the in game variable when new game begins.
     * @details This function resets all the values to their intial states when 
     * the game is first began when the player dies and wants to restart the game.
     * It does not reset the values when the game is paused.
     */  
    void startNewGame();

    /** 
     * @brief Check whether the button R was pressed or not to turn ON/OFF the shield.
     * @details When the button R is pressed it sets bool "is_shield_active" to its opposite
     * value. If the shield is active then, a ship with force shield sprite is drawn and
     * the player's ability to shoot deactivates.
     */
    bool forceShildActivate();
    
private:

    void checkButtonToShoot();
    bool checkForGameOver();
    void collideEnemiesAndBlasts();
    void collideEnemiesBlastsAndPlayer();
    void collideEnemiesAndPlayer();
    void collideBossAndPlayerBlasts();
    void collideBossBlastsAndPlayer();
    void starsSpawnDelay();
    void increaseGameDifficultyAndEnemySpawnDelay();
    void printMusicCountersTest();
    bool checkIfNeedsToReturnToMenu();
    void updateAndDrawGameplay();
    void updateAndDrawGameover();
    void updateAndDrawBossCutscene();
    void updateAndDrawBossGameplay();

    int enemy_ship_delay_counter;
    int enemy_ship_delay_max;
    bool is_boss_active;


    enum GameState {
        GameState_newgame,
        GameState_gameplay,
        GameState_boss_cutscene,
        GameState_boss_gameplay,
        GameState_gameover
    };
    GameState game_state;
};


#endif