#include "mbed.h"

/** Face class
*@brief A class used to instantiate a Face object, each cube will store 6 of these and will all be passed to the renderer to display the cube.
 Each Face object will be sorted in terms of its average z axis position upon which the renderer draws the faces from back to front to create depth.
*@author Christopher Doel
*@date April, 2019
*/
class Face {
  private:
    float verticies[4][3]; 
    float avgZ;
    bool visible;
  public:
    /** The constructor of the Face class which instantiates the face object.
    *No parameters are required as the face attributes will be defined after instantiation using the mutator methods.
    */
    Face();
    /** An accessor method which returns the value depending on the index of the vertex and the axis required
    *@param The index of which vertex is required
    *@param The axis of the 3 dimensional coordinate required
    @returns The float value of the required vertex in a specific axis
    */
    float getVertexValue(int vertex, int axis);
    /** An accessor method which returns whether the face is visible or not
    *@returns The boolean value of the attribute 'visible'
    */
    bool getVisible();
    /** A mutator method which sets whether the face is visible or not
    *@param A boolean which determines whether the visible attribute will be true or false
    */
    void setVisible(bool v);
     /** A mutator method which sets the verticies of the face
    *@param A memory address of a two dimentional array containing each vertex and the values of the x, y and z coordinates
    */
    void setVerticies(float (&PointArray)[4][3]);
    /** An accessor method which returns the average z axis value of the faces verticies
    *@returns A float representing the average z axis value of the face
    */
    float getAvgZ();
};