#ifndef FACE_H
#define FACE_H
#include "Face.h"
#endif

Face::Face() {
    visible = false; //Each instantiated face is not visible by default
}

bool Face::getVisible() { //Accessor returns whether the face is visible
    return visible;
}


void Face::setVisible(bool v) { //Mutator sets whether the face is visible or not
    visible = v;
}

void Face::setVerticies(float (&PointArray)[4][3]) { //Sets the verticies of the face to their xyz coordinate
    float z = 0;
    for(int vertex = 0; vertex < 4; vertex++) {
        for(int axis = 0; axis < 3; axis++) {
            verticies[vertex][axis] = PointArray[vertex][axis]; //copies the parameter to the private array
        }
        z += verticies[vertex][2];
    }
    avgZ = z/4; //store an average z axis value for each face
}

float Face::getVertexValue(int vertex, int axis){ //Accessor to return the value of a vertex depending on the index and axis
    return verticies[vertex][axis];
}

float Face::getAvgZ(){ //Accessor to return the average z value of the face
    return avgZ;
}