#include "mbed.h"
#ifndef FACE_H
#define FACE_H
#include "Face.h"
#endif

/** Cube class
*@brief A class used to instantiate a Cube object, this is the obstacle in the game and can be manipulated using the rotate and translate functions.
 The cubes will be constantly moving towards the user at an increasing speed proportional to the score, using the joystick will translate the cubes horizontally
 so that the user can dodge them.
*@author Christopher Doel
*@date April, 2019
*/
class Cube {
  private:
    float verticies[8][3];
    Face faces[6];
    float xPos, yPos, zPos;
    /** sets the verticies of all the cubes faces depending on the location and size of the cube
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for each 8 verticies
    */
    void updateFacesVerticies(float (&vert)[8][3]);
    /** sets the verticies of an individual face of the cube
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for the first face verticies
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for the second face verticies
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for the third face verticies
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for the fourth face verticies
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for the fifth face verticies
    *@param The memory address of the two dimentional float array which stores all x, y, z coordinates for the sixth faces verticies
    */
    void assignFacesVerticies(float (&face0Points)[4][3],
    float (&face1Points)[4][3], float (&face2Points)[4][3],
    float (&face3Points)[4][3], float (&face4Points)[4][3],
    float (&face5Points)[4][3]);

  public:
    /** The constructor of the Cube class which instantiates the cube object.
    *No parameters are required as the cube is initially created with a size of 5 and a position at the origin.
    */
    Cube();
    /** An accessor method which gets a face of the cube depending on the index provided
    *@param The integer index of the face required
    *@returns A face object corresponding to the index provided
    */
    Face getFace(int index);
    /** Sets the front, left and right faces of the cube to be visible so that they will be rendered (only these 3 are ever seen during gameplay)
    */
    void setPartiallyVisible();
        /** Sets the faces of the cube to be visible so that they will be rendered
    */
    void setVisible();
    /** Returns whether the cube is too close to the perspective of the user
    *@returns a boolean indicating whether it is too close or not
    */
    bool tooClose();
    /** Performs a rotation in the X axis about the cubes centre
    *@param The angle in which to rotate the cube in terms of radians, provided as a float
    */
    void rotateX(float angle);
    /** Performs a rotation in the Y axis about the cubes centre
    *@param The angle in which to rotate the cube in terms of radians, provided as a float
    */
    void rotateY(float angle);
    /** Performs a rotation in the Z axis about the cubes centre
    *@param The angle in which to rotate the cube in terms of radians, provided as a float
    */
    void rotateZ(float angle);
    /** Performs a translation in all axis
    *@param The x offset
    *@param The y offset
    *@param The z offset
    */
    void translate(float x, float y, float z);
    /** Resets the position of the cube to the origin
    */
    void resetPos();
    /** Returns whether the cube is behind the users perspective
    *@returns a boolean value as to whether it should be despawned or not
    */
    bool despawn();
};