//#include "mbed.h"
#ifndef CUBE_H
#define CUBE_H
#include "Cube.h"
#endif



Cube::Cube(){
    xPos = yPos = zPos = 0; //set cube position to origin and size to 5
    int size = 5;
    float v[8][3] = {{-size, size, -size}, //define xyz coordinates for all 8 verticies
    {-size, size, size},
    {size, size, size},
    {size, size, -size},
    {-size, -size, -size},
    {-size, -size, size},
    {size, -size, size},
    {size, -size, -size}};
    
    for(int vertex = 0; vertex < 8; vertex++){ //copy temporary array to private array
        for(int axis = 0; axis < 3; axis++){
            verticies[vertex][axis] = v[vertex][axis];
        }
    }
    updateFacesVerticies(verticies); //populate verticies of 6 faces
    setPartiallyVisible(); //set front, left and right faces to visible
    }

void Cube::setPartiallyVisible() {  //set front, left and right faces to be rendered(only these can be seen during gameplay)
    faces[1].setVisible(true);
    faces[3].setVisible(true);
    faces[4].setVisible(true);  
}

void Cube::setVisible() {  //set front, left and right faces to be rendered(only these can be seen during gameplay)
    faces[0].setVisible(true);
    faces[1].setVisible(true);
    faces[2].setVisible(true);
    faces[3].setVisible(true);
    faces[4].setVisible(true);
    faces[5].setVisible(true);  
}

void Cube::updateFacesVerticies(float (&vert)[8][3]) { //assign xyz coordinates for 6 faces
    float face0Points[4][3] = {{vert[0][0], vert[0][1], vert[0][2]},
    {vert[1][0],vert[1][1], vert[1][2]}, {vert[2][0], vert[2][1],
    vert[2][2]}, {vert[3][0],vert[3][1], vert[3][2]}};
    float face1Points[4][3] = {{vert[0][0], vert[0][1], vert[0][2]},
    {vert[1][0], vert[1][1], vert[1][2]}, {vert[5][0], vert[5][1],
    vert[5][2]}, {vert[4][0], vert[4][1], vert[4][2]}};
    float face2Points[4][3] = {{vert[1][0], vert[1][1], vert[1][2]},
    {vert[2][0], vert[2][1], vert[2][2]}, {vert[6][0], vert[6][1],
    vert[6][2]}, {vert[5][0], vert[5][1], vert[5][2]}};
    float face3Points[4][3] = {{vert[3][0], vert[3][1], vert[3][2]},
    {vert[2][0], vert[2][1], vert[2][2]}, {vert[6][0], vert[6][1],
     vert[6][2]}, {vert[7][0], vert[7][1], vert[7][2]}};
    float face4Points[4][3] = {{vert[0][0], vert[0][1], vert[0][2]},
    {vert[3][0], vert[3][1], vert[3][2]}, {vert[7][0], vert[7][1],
    vert[7][2]}, {vert[4][0], vert[4][1], vert[4][2]}};
    float face5Points[4][3] = {{vert[4][0], vert[4][1], vert[4][2]},
    {vert[5][0], vert[5][1], vert[5][2]}, {vert[6][0], vert[6][1],
    vert[6][2]}, {vert[7][0], vert[7][1], vert[7][2]}};
    assignFacesVerticies(face0Points, face1Points, face2Points, face3Points,
    face4Points, face5Points);//copy temporary arrays to all 6 faces private arrays
}

void Cube::assignFacesVerticies(float (&face0Points)[4][3], 
    float (&face1Points)[4][3], float (&face2Points)[4][3],
    float (&face3Points)[4][3], float (&face4Points)[4][3],
    float (&face5Points)[4][3]) { //set each faces verticies based on cubes verticies

    faces[0].setVerticies(face0Points);
    faces[1].setVerticies(face1Points);
    faces[2].setVerticies(face2Points);
    faces[3].setVerticies(face3Points);
    faces[4].setVerticies(face4Points);
    faces[5].setVerticies(face5Points);
}

Face Cube::getFace(int index) { //return face of certain index
    return faces[index];
}

bool Cube::tooClose() { //return if cube is a distance of 7 to origin
    if (sqrt(pow(xPos, 2) + pow(yPos, 2) + pow(zPos, 2)) < 7) { //use pythagoras to determine distance
        return true;
    }
    return false;
}

void Cube::rotateY(float angle) { //rotate cube in Y axis
    float originalX = xPos;
    float originalZ = zPos;
    float originalY = yPos;
    translate(-originalX, -originalY, -originalZ); //translate cube to origin

    
    for( int i = 0; i<8; i++){
        float x = verticies[i][0];
        float z = verticies[i][2];
        
        verticies[i][0] = x*cos(angle)-z*sin(angle); //perform rotation on all verticies
        verticies[i][2] = x*sin(angle)+z*cos(angle);
    }
    translate(originalX, originalY, originalZ); //translate back to original position
}


void Cube::rotateZ(float angle) { //rotate cube in Z axis
    float originalX = xPos;
    float originalZ = zPos;
    float originalY = yPos;
    translate(-originalX, -originalY, -originalZ); //translate cube to origin
    
    for( int i = 0; i<8; i++) {
        float y = verticies[i][1];
        float x = verticies[i][0];
        
        verticies[i][0] = x*cos(angle)-y*sin(angle); //perform rotation on all verticies
        verticies[i][1] = y*cos(angle)+x*sin(angle);
    }
    translate(originalX, originalY, originalZ); //translate back to original position
}

void Cube::rotateX(float angle) { //rotate cube in X axis
    float originalX = xPos;
    float originalZ = zPos;
    float originalY = yPos;
    translate(-originalX, -originalY, -originalZ); //translate cube to origin
    
    for( int i = 0; i<8; i++) {
        float y = verticies[i][1];
        float z = verticies[i][2];
        
        
        verticies[i][1] = y*cos(angle)-z*sin(angle); //perform rotation on all verticies
        verticies[i][2] = z*cos(angle)+y*sin(angle);
        
    }
    translate(originalX, originalY, originalZ); //translate back to original position
}


void Cube::translate(float x, float y, float z) { //translate cube by xyz amount
    xPos += x; //translate cube cooridnates
    yPos += y;
    zPos += z;
    
    for( int i = 0; i<8; i++) {
        verticies[i][0] += x; //translate vertex coorinates
        verticies[i][1] += y;
        verticies[i][2] += z;
    }
    updateFacesVerticies(verticies); //update all face verticies
}

void Cube::resetPos() { //translate cube to origin
    float x = xPos;
    float y = yPos;
    float z = zPos;
    
    xPos = 0; //set cube position to 0 on all axis'
    yPos = 0;
    zPos = 0;
    
    for( int i = 0; i<8; i++) {
        verticies[i][0] -= x; //translate verticies by negative of current position
        verticies[i][1] -= y;
        verticies[i][2] -= z;
    }
    updateFacesVerticies(verticies);  //update all face verticies
}

bool Cube::despawn() { //Accessor to return whether the cube is behind perspective
    if(zPos < 0){
        return true;
    }
    return false;
}