/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Andrew Milner
Username: el17arm
Student ID Number: 201162219
Date: 18/03/19
*/

///////// pre-processor directives //////////


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Gameengine.h"

#define WITH_TESTING

#ifdef WITH_TESTING
#include "tests.h"
#endif


/////////////// objects ///////////////

Gameengine game;
Gamepad pad;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
AnalogIn pot0(PTB2);
BusOut oxygen(PTA1, PTA2, PTC2);
BusOut lives(PTC3, PTC4, PTD3);

///////////// prototypes ///////////////

/**
  * @brief sets the contrast of lcd screen
  * @details contrast is adjust with analog input PTB2
  */
void contrast();
/** Initialises all classes and libraries and default game settings
  * @details initialises LCD and gamepad library and sets screen brightness
  */
void init();
/** Displays opening screen
  * @details Screen displays title of game and instructs player to press start to begin
  */
void start_screen();
/** Controls LEDs on front panel.
  * @details Every time a player dies a RHS LED is turned off, as time reduces
  * LEDs turn off on LHS.
  */
void leds();
/** Initialises and renders all level objects
  * @details Contains functions for all levels and will display next level objects
  * once player has completed each level
  */
void render();
/** Displays screen if game over or game complete
  * @details Screen will display player's final score and display game over or game complete
  */
void restart();
/** Displays options screen
  * @details gives player controls for game
  */
void option_screen();

bool options_flag = false;

///////////// functions ////////////////

int main()
{   
    #ifdef WITH_TESTING
    run_tests(lcd);
    #endif
    
    init();     // initialises screen and default game settings
    start_screen();     // waits for user to press start to begin
    option_screen(); // displays options screen

    // game loop, reads input and updates game accordingly
    while (1) {

        contrast();     // adjusts contrast of screen
        render();       // draws all level objects on to screen
        game.update(lcd, pad); // updates movement, collected keys, lives, time left
        restart();      // restart screen if game over or end screen if game complete displays final score
        wait(0.1);      // wait function to control fps
    }
}


//initialises all classes and libraries and default game settings
void init()
{
    lcd.init();
    lcd.normalMode();      // normal colour mode
    lcd.refresh();
    lcd.setBrightness(1.0);
    pad.init();
    game.game_init();
}

// detects which level is being played and draws the level objects with collision settings
void render()
{
    game.draw_l1(lcd, pad); // level 1
    game.draw_l2(lcd, pad); // level 2
    game.draw_l3(lcd, pad); // level 3
    game.draw_l4(lcd, pad); // level 4
    leds();                 // function to update leds to reflect time and lives left
}

// controls contrast of the screen
void contrast()
{
    lcd.refresh();
    float con = pot0.read();
    lcd.setContrast(con);
    lcd.clear();
}

// displays start screen and waits for user to press start
void start_screen()
{
    while (pad.check_event(Gamepad::START_PRESSED) == false && options_flag == false) {
        lcd.clear();
        lcd.drawSprite(2,20,8,3,(int *)miner_right);
        lcd.drawSprite(79,20,8,3,(int *)miner_left);
        lcd.drawRect(0,0,84,48, FILL_TRANSPARENT);
        lcd.printString("MANIC MILNER",7,1);
        lcd.printString("Press start!",8,2);
        lcd.printString("A = Controls",6,4);
        contrast();
        //printf("start screen = %d \n",options_flag);
        if (pad.check_event(Gamepad::A_PRESSED) == true) {
            options_flag = true;
            //printf("options = %d \n",options_flag);
        }
    }
}
// displays options screen
void option_screen()
{
    while (options_flag == true) {
        lcd.clear();
        lcd.printString("Stick = L/R",0,0);
        lcd.printString("A = Jump ",0,1);
        lcd.printString("Get keys and",0,2);
        lcd.printString("return to exit",0,3);
        lcd.printString("Led=time/lives",0,4);
        lcd.printString("<< Press back",0,5);
        //printf("options screen = %d \n",options);
        lcd.refresh();
        if (pad.check_event(Gamepad::BACK_PRESSED) == true) {
            options_flag = false;
            start_screen();
        }
    }
}

// displays appropriate screen with final score for game over and game complete
void restart()
{
    if (game.game_over() == true) {
        lcd.clear();
        game.get_score(lcd);
        lcd.drawRect(0,0,84,48, FILL_TRANSPARENT);
        lcd.printString("Game Over! ",14,1);
        lcd.printString("Score ",18,2);
        lcd.printString("Back = Replay",3,4);
    }
    if (game.game_complete(lcd) == true) {
        lcd.clear();
        game.get_score(lcd);
        lcd.printString("YOU WIN!!! ",12,1);
        lcd.printString("Score ",18,2);
        lcd.printString("Well done!!!",8,4);
    }
    if(pad.check_event(Gamepad::BACK_PRESSED) == true) {
        init();
    }
}

// leds indicate how many lives and time left
void leds()
{
    // fsm to display lives left
    int l_leds[4]  = {0b111,0b110,0b100,0b000};
    //fsm to display how much time (oxygen) left
    int r_leds[4]  = {0b111,0b110,0b100,0b000};

    // function keeps track of time elapsed and changes leds accordingly
    oxygen = l_leds[game.oxygen_leds()];
    // function keeps track of lives left and changes leds accordingly
    lives = r_leds[game.lives_leds()];
}