#include "Sprites.h"

Sprites::Sprites()
{
    _j_flag = false; // indicates when player can jump so player cannot perform midair jump
}

Sprites::~Sprites()
{
}
// player starting position
void Sprites::miner_init(int x, int y)
{
    _x = x;
    _y = y;
    
}

// vector gets player position
Vector2D Sprites::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
    //printf("x pos = %d \n",_x);
    //printf("y pos = %d \n",_Y);
}

// player movement and updates which way player is facing
void Sprites::miner_move(Direction d, N5110 &lcd)
{
    if ((d==E || d==NE) && block_collision() == false) {
        _x++;
        _direction = 1; //chooses right facing sprite
    }
    if ((d==W || d==NW) && block_collision() == false) {
        _x--;
        _direction = 0; //chooses left facing sprite
    }
    // ensures player cannot move off side of screen
    if(_x > 81) {
        _x=WIDTH-3;
    }
    if(_x < 0) {
        _x=0;
    }
}

// draws left or right facing sprite based on miner_move function
void Sprites::miner_draw(N5110 &lcd)
{
    if (_direction == 1) {
        lcd.drawSprite(_x,_y,8,3,(int *)miner_right);
    }
    if (_direction == 0) {
        lcd.drawSprite(_x,_y,8,3,(int *)miner_left);
    }
    //printf("direction = %d \n", _direction);  
}
// ensures player cannot multiple jump and lands on platforms
void Sprites::miner_land(N5110 &lcd)
{
    _jump = lcd.getPixel(_x+2,_y+8) || lcd.getPixel(_x,_y+8) || lcd.getPixel(_x+1,_y+8);
    // _jump only true if part of player is on a platform
    _gravity = !lcd.getPixel(_x,_y+8) && !lcd.getPixel(_x+2, _y+8);
    //_gravity true when players feet are not touching a platform
}

// updates player position while jumping
void Sprites::miner_jump(N5110 &lcd, Gamepad &pad)
{
    // jumps when player on ground, sets jump flag to true to prevent mid air jumping
    if(pad.check_event(Gamepad::A_PRESSED) && _jump == true) {
        _j_flag = true;
    }
    // jumps until preset jump limit is reached
    if(_j_flag == true) {
        _y--;
        _j_counter++;
        pad.tone(400 +_j_counter*10,0.1);
    }
    // resets jump flag and counter once jump is complete
    if(_j_counter > 7) {
        _j_flag = false;
        _j_counter = 0;
    }
    //printf("_jump = %d \n",_jump);
    //printf("_j_counter = %d \n",_j_counter);
}

// makes player fall if not on platform
void Sprites::miner_gravity(N5110 &lcd)
{
    if(_gravity == true) {
        _y++;
        //printf("_y = %d \n",_y;
    }
}

// initilises starting positions of all enemies
void Sprites::enemy_init(int i, int x, int y, int d)
{
    _counter[i] = 0;    // resets enemy counter when level complete
    _eflag[i] = false; // stops function once enemies inialised
    _ex[i] = x;        // sets x position of enemy
    _ey[i] = y;        // sets y position of enemy
    _distance[i] = d;  // sets distance enemy will move before turning
}

// updates enemy movements
void Sprites::enemy_move(int i, double v, N5110 &lcd)
{
    // draws enemies, indexed so each enemy treated indepently,
    lcd.drawSprite(_ex[i],_ey[i],5,3, (int *) enemy);
    if (_eflag[i] == false) {      // flag states when enemy should move in opposite direction
        _ex[i] = _ex[i] + v;  // enemy moves in x direction
        _counter[i]++;             // counter to control distance
    }
    if(_counter[i] == _distance[i]) {
        _eflag[i] = true;
    }
    if (_eflag[i] == true) {
        _ex[i] = _ex[i] - v;  // enemy will now move in opposite direction
        _counter[i]--;             // counter goes downwards
    }
    if (_counter[i] == 0) {
        _eflag[i] = false;         // when counter reaches zero, restarts from top
    }
}
// detects if player comes into contact with enemy
bool Sprites::enemy_collision(int i)
{
    Vector2D p = get_pos(); // gets player position for collision detection
    //checks collision by checking for overlap of sprites
    if (p.x < _ex[i] + 2 && p.x + 2 > _ex[i] && p.y < _ey[i] + 4
            && p.y + 8 > _ey[i]) {
        return true;
    }
    return false;
    //printf("_ex = %d \n",_ex);
    //printf("p.x = %d \n",p.x);
    //printf("_ey = %d \n",_ey);
    //printf("p.y = %d \n",p.y);
}

// detects when key is collected and adds to total, all parameters
void Sprites::key_collect(int k, int x, int y, N5110 &lcd, Gamepad &pad)
{
    Vector2D p = get_pos();
    _kx[k] = x;
    _ky[k] = y;

    // draws keys all parameters indexed so multiple keys are treated independently
    if(_key[k] == false) {
        lcd.drawSprite(_kx[k],_ky[k],3,4,(int *)key);
    }
    //checks collision by checking for overlap of sprites
    if ((p.x < _kx[k] + 5 && p.x + 3 > _kx[k] && p.y < _ky[k] + 3
            && p.y + 9 > _ky[k]) && _key[k] == false) {
        _keys++;
        pad.tone(850,0.1);
        lcd.drawSprite(_kx[k],_ky[k],3,4,(int *)key_collected); // deletes key on screen
        _key[k]= true;    // stops key being redrawn once collected
        //printf("_key = %d \n",_key[k]);
    }
}
// keeps count of keys collected
int Sprites::keys_collected()
{
    int k = _keys;
    //printf("keys = %d \n",_keys);
    return k;
}

void Sprites::zero_keys() {
    _keys = 0;
}

// checks if sprite is at the level exit
bool Sprites::exit_level(int x, int y, N5110 &lcd)
{
    Vector2D p = get_pos(); // gets player position
    lcd.drawSprite(x,y,6,5,(int *)door); // draws level exit

    // //checks collision by checking for overlap of sprites
    if(p.x < x + 5 && p.x + 3 > x && p.y < y + 2
            && p.y + 9 > y) {
        return true;
    }
    return false;
}

bool Sprites::trap(int x, int y, N5110 &lcd)
{
    Vector2D p = get_pos(); // gets miner position
    lcd.drawSprite(x,y,3,3,(int *)spike); // draws traps

    //checks collision by checking for overlap of sprites
    if (p.x < x + 3 && p.x + 3 > x && p.y < y + 2
            && p.y + 8 > y) {
        return true;
    }
    return false;
}

void Sprites::blocks(Direction d, int b, int x, int y, N5110 &lcd)
{
    Vector2D p = get_pos(); // gets miner position
    _bx[b] = x;   // sets each block position independently so no collision rule clashes
    _by[b] = y;

    lcd.drawSprite(_bx[b],_by[b],3,6,(int *)solid_block); // draws blocks

    //checks collision by checking for overlap of sprites
    if (p.x < _bx[b] + 7 && p.x + 4 > _bx[b] && p.y < _by[b] + 3 && p.y + 9 > _by[b]) {
        _collision[b] = true;
        
        // allows player to move away from block after collision or jump over block
        if ((p.x +3  <= _bx[b] && d == W) || (p.x >= _bx[b] +6  && d == E) || (p.y + 7 <  _by[b])) {
            _collision[b] = false;
        }
        // player cannot jump through blocks from below
        if (p.x < _bx[b] + 5 && p.x + 3  > _bx[b] && p.y < _by[b] +3 ) {
            _j_flag = false;
        }
    } else {
        _collision[b] = false;
    }
    //printf("_collision = %d \n",_collision[b]);
}

// checks block collision with each block placed
bool Sprites::block_collision()
{
    if (_collision[0] || _collision[1] || _collision[2] || _collision[3]
            || _collision[4]) {
        return true;
    }
    return false;
}

void Sprites::soft_blocks(int x1, int y, int x2, N5110 &lcd)
{
    Vector2D p = get_pos(); //gets miner position

    lcd.drawLine(x1,y,x2,y,1);      // draws top solid part
    lcd.drawLine(x1,y+1,x2,y+1,2); // draws dotted bottom part

    // checks contact with top part
    if (p.x < x2 && p.x + 2 > x1 && p.y < y && p.y + 9 > y) {
        lcd.drawLine(x1,y,x2,y,0); // removes top part
    }
    // checks contact with bottom part
    if (p.x < x2 && p.x + 2 > x1 && p.y < y +1 && p.y + 9 > y +1) {
        lcd.drawLine(x1,y+1,x2,y+1,0); // removes bottom part
    }
}