#ifndef Levels_H
#define Levels_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Sprites.h"

/////////////Structs for populating up to 6 levels//////////////////

/** Enemy locations for each level struct */
struct Enemies {
    double ex[5]; /**< enemy x positions for each level */
    double ey[5]; /**< enemy y positions for each level */
    int c[5];     /**< enemy counters for each level */
    int d[5];     /**< enemy travel distances for each level */
    double v[5];  /**< varies enemies velocity */
};
/** Trap locations for each level struct */
struct Traps {
    double tx[5];   /**< traps x positions for each level */
    double ty[5];   /**< traps y positions for each level */
};
/** Key locations for each level struct*/
struct Keys {
    double kx[5];   /**< keys x positions for each level */
    double ky[5];   /**< keys y positions for each level */
};
/** block locations for each level struct*/
struct Solid_blocks {
    double bx[5];   /**< blocks x positions for each level */
    double by[5];   /**< blocks y positions for each level */
};
/** sinking block locations for each level struct*/
struct Soft_blocks {
    double sx1[5];  /**< sinking blocks x1 positions for each level */
    double sy[5];   /**< sinking blocks y positions for each level */
    int sx2[5];     /**< sinking blocks x2 (length) positions for each level */
};

/** Levels Class
@details Sets position of all level objects
@author Andrew Milner University of Leeds
@date April 2019
*/ 

class Levels
{
public:
    /** Constructor
    */
    Levels();
    /** Deconstructor
    */
    ~Levels();
    /** Level 1 platform positions
    */    
    void level_platforms1(N5110 &lcd);
    /** Level 1 trap positions
    */    
    void trap_pos1();
    /** Level 1 key positions
    */    
    void key_pos1();
    /** Level 1 block positions
    */    
    void block_pos1();
    /** Level 1 sinking block positions
    */    
    void soft_pos1();
    /** Level 1 enemy positions
    */    
    void enem_pos1();
    
    /** Level 2 platform positions
    */    
    void level_platforms2(N5110 &lcd);
    /** Level 2 key positions
    */ 
    void key_pos2();
    /** Level 2 trap positions
    */ 
    void trap_pos2();
    /** Level 2 enemy positions
    */ 
    void enem_pos2();
    /** Level 2 block positions
    */ 
    void block_pos2();
    /** Level 2 sinking block positions
    */ 
    void soft_pos2();
    
    /** Level 3 platform positions
    */ 
    void level_platforms3(N5110 &lcd);
    /** Level 3 key positions
    */ 
    void key_pos3();
    /** Level 3 trap positions
    */ 
    void trap_pos3();
    /** Level 3 enemy positions
    */ 
    void enem_pos3();
    /** Level 3 block positions
    */ 
    void block_pos3();
    /** Level 3 sinking block positions
    */ 
    void soft_pos3();
    
    /** Level 4 platform positions
    */ 
    void level_platforms4(N5110 &lcd);
    /** Level 4 key positions
    */ 
    void key_pos4();
    /** Level 4 trap positions
    */ 
    void trap_pos4();
    /** Level 4 enemy positions
    */ 
    void enem_pos4();
    /** Level 4 block positions
    */ 
    void block_pos4();
    /** Level 4 sinking block positions
    */ 
    void soft_pos4();
    
    
    Traps trap1, trap2, trap3, trap4, trap5;
    Keys key1, key2, key3, key4, key5;
    Solid_blocks sol1, sol2, sol3, sol4, sol5;
    Soft_blocks sof1, sof2, sof3, sof4, sof5;
    Enemies enem1, enem2, enem3;
    
private:
    
    Sprites _sprites;
    Direction _d;
    
};
#endif