#include "Levels.h"

Levels::Levels()
{
}

Levels::~Levels()
{
}
/////////////////level 1 objects /////////////////////////

// Generates all standard platforms for level 1
void Levels::level_platforms1(N5110 &lcd)
{
    lcd.drawLine(0,47,83,47, 1);
    lcd.drawRect(11,39, 38, 2, FILL_BLACK);
    lcd.drawRect(65,36, 30, 2, FILL_BLACK);
    lcd.drawRect(75,29, 9, 2, FILL_BLACK);
    lcd.drawRect(22, 25, 48, 2, FILL_BLACK);
    lcd.drawRect(0, 25, 12, 2, FILL_BLACK);
    lcd.drawRect(0, 17, 8, 2, FILL_BLACK);
    lcd.drawRect(0, 9, 27, 2, FILL_BLACK);
    lcd.drawRect(39, 9, 7, 2, FILL_BLACK);
    lcd.drawRect(53,9,32,2,FILL_BLACK);
}

// sets positions of all traps level 1
void Levels::trap_pos1()
{
    trap1.tx[0] = 25;
    trap1.ty[0] = 44;
    trap2.tx[0] = 58;
    trap2.ty[0] = 6;
    trap3.tx[0] = 75;
    trap3.ty[0] = 6;
    trap4.tx[0] = 0;
    trap4.ty[0] = 0;
    trap5.tx[0] = 25;
    trap5.ty[0] = 36;
}

// sets all key positions for keys
void Levels::key_pos1()
{
    key1.kx[0] = 79;
    key1.ky[0] = 12;
    key2.kx[0] = 36;
    key2.ky[0] = 22;
    key3.kx[0] = 40;
    key3.ky[0] = 6;
    key4.kx[0] = 62;
    key4.ky[0] = 6;
    key5.kx[0] = 75;
    key5.ky[0] = 0;
}

// sets all block positions for level 1
void Levels::block_pos1()
{
    sol1.bx[0] = 49;
    sol1.by[0] = 36;
    
    sol2.bx[0] = 42;
    sol2.by[0] = 22;
    
    sol3.bx[0] = -10;
    sol3.by[0] = -10;
    
    sol4.bx[0] = -10;
    sol4.by[0] = -10;
    
    sol5.bx[0] = -10;
    sol5.by[0] = -10;
}

// sets all sinking block positions for level 1
void Levels::soft_pos1()
{    
    sof1.sx1[0] = 55;
    sof1.sy[0] = 36;
    sof1.sx2[0] = 65;
    
    sof2.sx1[0] = 27;
    sof2.sy[0] = 9;
    sof2.sx2[0] = 39;
    
    sof3.sx1[0] = 46;
    sof3.sy[0] = 9;
    sof3.sx2[0] = 52;
    
}

// sets all enemy positions for level 1
void Levels::enem_pos1()
{
    enem1.ex[0] = 22;
    enem1.ey[0] = 20;
    enem1.d[0] = 36;
    enem1.v[0] = 0.5;
    
    enem2.ex[0] = 0;
    enem2.ey[0] = 4;
    enem2.d[0] = 26;
    enem2.v[0] = 1;
    
    enem3.ex[0] = 49;
    enem3.ey[0] = 42;
    enem3.d[0] = 27;
    enem3.v[0] = 1;
}

/////////////////level 2 objects /////////////////////////

// platform positions for level 2
void Levels::level_platforms2(N5110 &lcd)
{
    lcd.drawLine(0, 47, 83, 47, 1);
    lcd.drawRect(4, 33, 12, 2, FILL_BLACK);
    lcd.drawRect(20, 41, 12, 2, FILL_BLACK);
    lcd.drawRect(36, 37, 12, 2, FILL_BLACK);
    lcd.drawRect(48, 29, 12, 2, FILL_BLACK);
    lcd.drawRect(24, 21, 24, 2, FILL_BLACK);
    lcd.drawRect(20, 10, 29, 2, FILL_BLACK);
    lcd.drawRect(54, 14, 12, 2, FILL_BLACK);
    lcd.drawRect(0, 10, 10, 2, FILL_BLACK);
}

// key positions for level 2
void Levels::key_pos2()
{
    key1.kx[1] = 55;
    key1.ky[1] = 44;
    
    key2.kx[1] = 79;
    key2.ky[1] = 29;
    
    key3.kx[1] = 72;
    key3.ky[1] = 23;
    
    key4.kx[1] = 24;
    key4.ky[1] = 0;
    
    key5.kx[1] = 1;
    key5.ky[1] = 7;
}

// trap positions for level 2
void Levels::trap_pos2()
{
    trap1.tx[1] = 30;
    trap1.ty[1] = 7;
    
    trap2.tx[1] = 72;
    trap2.ty[1] = 17;
    
    trap3.tx[1] = 51;
    trap3.ty[1] = 44;
    
    trap4.tx[1] = 42;
    trap4.ty[1] = 7;
    
    trap5.tx[1] = 80;
    trap5.ty[1] = 35;
}

// enemy positions for level 2
void Levels::enem_pos2()
{
    enem1.ex[1] = 24;
    enem1.ey[1] = 16;
    enem1.d[1] = 44;
    enem1.v[1] = 0.5;
    
    enem2.ex[1] = 20;
    enem2.ey[1] = 5;
    enem2.d[1] = 27;
    enem2.v[1] = 1;
    
    enem3.ex[1] = 54;
    enem3.ey[1] = 42;
    enem3.d[1] = 30;
    enem3.v[1] = 1;
}

// block positions for level 2
void Levels::block_pos2()
{
    sol1.bx[1] = 66;
    sol1.by[1] = 38;
    
    sol2.bx[1] = 66;
    sol2.by[1] = 32;
    
    sol3.bx[1] = 66;
    sol3.by[1] = 26;
    
    sol4.bx[1] = 66;
    sol4.by[1] = 20;
    
    sol5.bx[1] = 66;
    sol5.by[1] = 14;
}

// sinking block positions for level 2
void Levels::soft_pos2()
{
    sof1.sx1[1] = 72;
    sof1.sy[1] = 38;
    sof1.sx2[1] = 84; 
       
    sof2.sx1[1] = 72;
    sof2.sy[1] = 32;
    sof2.sx2[1] = 84;   
     
    sof3.sx1[1] = 72;
    sof3.sy[1] = 26;
    sof3.sx2[1] = 84; 
       
    sof4.sx1[1] = 72;
    sof4.sy[1] = 20;
    sof4.sx2[1] = 84;   
     
    sof5.sx1[1] = 72;
    sof5.sy[1] = 14;
    sof5.sx2[1] = 84;
}

/////////////////level 3 objects /////////////////////////

// platform positions for level 3
void Levels::level_platforms3(N5110 &lcd)
{
    lcd.drawLine(0, 47, 83, 47, 1);
    lcd.drawRect(36, 31, 6, 2, FILL_BLACK);
    lcd.drawRect(30, 10, 42, 2, FILL_BLACK);
    lcd.drawRect(78, 20, 6, 2, FILL_BLACK);
    lcd.drawRect(66, 26, 10, 2, FILL_BLACK);
    lcd.drawRect(54, 30, 10, 2, FILL_BLACK);
    
}

// key positions for level 3
void Levels::key_pos3()
{
    key1.kx[2] = 38;
    key1.ky[2] = 7;
    
    key2.kx[2] = 66;
    key2.ky[2] = 7;
    
    key3.kx[2] = 0;
    key3.ky[2] = 5;
    
    key4.kx[2] = 57;
    key4.ky[2] = 27;
    
    key5.kx[2] = 69;
    key5.ky[2] = 23;
}

// trap positions for level 3
void Levels::trap_pos3()
{
    trap1.tx[2] = 54;
    trap1.ty[2] = 27;
    
    trap2.tx[2] = 66;
    trap2.ty[2] = 23;
    
    trap3.tx[2] = 61;
    trap3.ty[2] = 27;
    
    trap4.tx[2] = 73;
    trap4.ty[2] = 23;
    
    trap5.tx[2] = 52;
    trap5.ty[2] = 7;
}

// enemy positions for level 3
void Levels::enem_pos3()
{
    enem1.ex[2] = 49;
    enem1.ey[2] = 5;
    enem1.d[2] = 33;
    enem1.v[2] = 1;
    
    enem2.ex[2] = 30;
    enem2.ey[2] = 5;
    enem2.d[2] = 42;
    enem2.v[2] = 1.25;
    
    enem3.ex[2] = 35;
    enem3.ey[2] = 5;
    enem3.d[2] = 20;
    enem3.v[2] = 1;
}

// block positions for level 3
void Levels::block_pos3()
{
    sol1.bx[2] = 15;
    sol1.by[2] = 39;
    
    sol2.bx[2] = 30;
    sol2.by[2] = 31;
    
    sol3.bx[2] = 15;
    sol3.by[2] = 23;
    
    sol4.bx[2] = 0;
    sol4.by[2] = 8;
    
    sol5.bx[2] = 0;
    sol5.by[2] = 16;
}

// sinking block positions for level 3
void Levels::soft_pos3()
{
    sof1.sx1[2] = 12;
    sof1.sy[2] = 16;
    sof1.sx2[2] = 24; 
       
    sof2.sx1[2] = 72;
    sof2.sy[2] = 10;
    sof2.sx2[2] = 84;   
     
}

/////////////////level 4 objects /////////////////////////

void Levels::level_platforms4(N5110 &lcd)
{
    lcd.drawLine(0, 47, 83, 47, 1);
    lcd.drawRect(36, 31, 6, 2, FILL_BLACK);
    lcd.drawRect(30, 10, 42, 2, FILL_BLACK);
    lcd.drawRect(78, 20, 6, 2, FILL_BLACK);
    lcd.drawRect(66, 26, 10, 2, FILL_BLACK);
    lcd.drawRect(54, 30, 10, 2, FILL_BLACK);
    
}

// key positions for level 4
void Levels::key_pos4()
{
    key1.kx[3] = 38;
    key1.ky[3] = 7;
    
    key2.kx[3] = 66;
    key2.ky[3] = 7;
    
    key3.kx[3] = 0;
    key3.ky[3] = 5;
    
    key4.kx[3] = 57;
    key4.ky[3] = 27;
    
    key5.kx[3] = 69;
    key5.ky[3] = 23;
}

// trap positions for level 4
void Levels::trap_pos4()
{
    trap1.tx[3] = 54;
    trap1.ty[3] = 27;
    
    trap2.tx[3] = 66;
    trap2.ty[3] = 23;
    
    trap3.tx[3] = 61;
    trap3.ty[3] = 27;
    
    trap4.tx[3] = 73;
    trap4.ty[3] = 23;
    
    trap5.tx[3] = 52;
    trap5.ty[3] = 7;
}

// enemy positions for level 4
void Levels::enem_pos4()
{
    enem1.ex[3] = 49;
    enem1.ey[3] = 5;
    enem1.d[3] = 33;
    enem1.v[3] = 1;
    
    enem2.ex[3] = 30;
    enem2.ey[3] = 5;
    enem2.d[3] = 42;
    enem2.v[3] = 1.25;
    
    enem3.ex[3] = 35;
    enem3.ey[3] = 5;
    enem3.d[3] = 20;
    enem3.v[3] = 1;
}

// block positions for level 4
void Levels::block_pos4()
{
    sol1.bx[3] = 15;
    sol1.by[3] = 39;
    
    sol2.bx[3] = 30;
    sol2.by[3] = 31;
    
    sol3.bx[3] = 15;
    sol3.by[3] = 23;
    
    sol4.bx[3] = 0;
    sol4.by[3] = 8;
    
    sol5.bx[3] = 0;
    sol5.by[3] = 16;
}

// sinking block positions for level 4
void Levels::soft_pos4()
{
    sof1.sx1[3] = 12;
    sof1.sy[3] = 16;
    sof1.sx2[3] = 24; 
       
    sof2.sx1[3] = 72;
    sof2.sy[3] = 10;
    sof2.sx2[3] = 84;   
}