#include "Gameengine.h"

Gameengine::Gameengine()
{
}
Gameengine::~Gameengine()
{
}
//initialises default game parameters
void Gameengine::game_init()
{
    _enem_flag = false;     // flag to initialise enemies each new level
    _key_reinit = false;    // re initialise keys at start of new level
    _five_keys = 5;         // number of keys to advance to next level   
    _level = 0;              //start level
    _sprites.miner_init(3, 37); //start position of player
    _lives = 3;             // starting lives
    _time = 120;            // time to complete each level
    _t.reset();             // resets timer to zero
    _sprites.zero_keys();    // resets keys collected to zero
}
// updates player position and interaction with level objects
void Gameengine::update(N5110 &lcd, Gamepad &pad)
{
    read_direction(pad);
    _sprites.miner_draw(lcd);
    _sprites.miner_move(_d, lcd);
    _sprites.miner_gravity(lcd);
    _sprites.miner_jump(lcd, pad);
    _sprites.miner_land(lcd);
    _sprites.keys_collected();
    key_draw(lcd, pad);
    lose_life(pad, lcd);
    game_over();
    next_level(lcd, pad);
    oxygen_leds();
    lives_leds();
    //printf("_x = %d \n",_sprites._x);
    //printf("_y = %d \n",_sprites._y);
}
// draws level 1 objects
void Gameengine::draw_l1(N5110 &lcd, Gamepad &pad)
{
    if (_level == 0) {

        _t.start();                 // starts level timer
        key_reinit();
        _lev.level_platforms1(lcd); // position of platforms
        _lev.key_pos1();            // key positions
        _lev.trap_pos1();           // trap positions
        _lev.block_pos1();          // solid block positions
        _lev.soft_pos1();           // sinking block positions
        _lev.enem_pos1();           // enemy positions
        blocks(lcd);                // block placement and collision settings
    }
}
// draws level 2 objects
void Gameengine::draw_l2(N5110 &lcd, Gamepad &pad)
{
    if(_level == 1) {

        _t.start();
        key_reinit();               // re-sets key settings so they appear and disappear once collected
        _lev.level_platforms2(lcd);
        _lev.key_pos2();
        _lev.trap_pos2();
        _lev.block_pos2();
        _lev.soft_pos2();
        _lev.enem_pos2();
        blocks(lcd);
        //printf("_level = %d \n",_level);
    }
}
// draws level 3 objects
void Gameengine::draw_l3(N5110 &lcd, Gamepad &pad)
{
    if(_level == 2) {
        
        _t.start();
        key_reinit();
        _lev.level_platforms3(lcd);
        _lev.key_pos3();
        _lev.trap_pos3();
        _lev.block_pos3();
        _lev.soft_pos3();
        _lev.enem_pos3();
        blocks(lcd);
    }
}

void Gameengine::draw_l4(N5110 &lcd, Gamepad &pad)
{
    if(_level == 3) {
        
        _t.start();
        key_reinit();
        _lev.level_platforms4(lcd);
        _lev.key_pos4();
        _lev.trap_pos4();
        _lev.block_pos4();
        _lev.soft_pos4();
        _lev.enem_pos4();
        blocks(lcd);
        game_complete(lcd);     // displays game complete screen
    }
}

// reads direction of joystick
void Gameengine::read_direction(Gamepad &pad)
{
    _d = pad.get_direction();
}

// turns off LEDS proportionally Vs time left to complete level
int Gameengine::oxygen_leds()
{
    if(_t.read() < (_time*0.33f)) {
        _oxy_state = 3;
    }
    if(_t.read() > (_time*0.33f) && _t.read() < (_time*0.66f)) {
        _oxy_state = 2;
    }
    if(_t.read() > (_time*0.66f)) {
        _oxy_state = 1;
    }
    if(_t.read() >= _time) {
        _oxy_state = 0;
    }
    return _oxy_state; // _oxy_state will change FSM value in main.cpp leds()
}

// turns off led every time life is lost
int Gameengine::lives_leds()
{
    _life_state = _lives;
    return _life_state; // _life_state will change FSM value in main.cpp leds()
}

// displays score at end of game
void Gameengine::get_score(N5110 &lcd)
{   
    // score is, time left at each level + 10 points for each key, if game completed time is multiplied by lives left
    float flt_score = ((_lives +1) * _total_time + (10 * _sprites.keys_collected()));
    //printf("flt_score = %d \n",flt_score);
    int int_score = static_cast<int>(flt_score); //converts float to integer
    char buffer[14];
    sprintf(buffer,"%2d",int_score);
    lcd.printString(buffer,54,2);
}

// returns true final level complete
bool Gameengine::game_complete(N5110 &lcd)
{
    if(_level == 4) {
        return true;
    }
    return false;
}

void Gameengine::lose_life(Gamepad &pad, N5110 &lcd)
{
    if (trap_death(lcd) == true || enemies(lcd) == true) {
        _lives--;                      //reduces lives left by 1
        pad.tone(200, 0.5);         // death sound
        _sprites.miner_init(3, 37); // puts player back to start of level
        wait(1);                    //short pause so restart isn't instant
    }
}

// game over when lives lost or time runs out
bool Gameengine::game_over()
{
    if(_lives == 0 || _t.read() > _time) {
        _t.stop();
        _lives = 0; // lives reduced to zero if time runs out
        printf("total time %f \n", _total_time);
        return true;
    }
    return false;
}

// activates level exit when all keys collected
bool Gameengine::level_exit(N5110 &lcd)
{
    if(_sprites.exit_level(79,41,lcd) == true) {
        return true;
    } else {
        return false;
    }
}

// if keys collected and player reaches exit, sets next level parameters
void Gameengine::next_level(N5110 &lcd, Gamepad &pad)
{
    if(level_exit(lcd) && _sprites.keys_collected() == _five_keys) {
        _t.stop();                          // stops level timer
        _total_time += (_time - _t.read()); // adds up time left for score calculation
        _level = _level++;                  // next level activated
        _five_keys += 5;                    // raises keys needed by 5 for next level
        _sprites.miner_init(3,39);          // resets player position
        _enem_flag = false;                 // allows enemies to be reinitialised
        _key_reinit = false;                // allows keys to be reintialised
        _t.reset();                         // resets level timer
        pad.tone(700, 0.5);
    }
}

// places traps and checks if collision with player
bool Gameengine::trap_death(N5110 &lcd)
{
    int i = _level; // tells function which level settings to use 
    if( _sprites.trap(_lev.trap1.tx[i], _lev.trap1.ty[i], lcd) ||
            _sprites.trap(_lev.trap2.tx[i], _lev.trap2.ty[i], lcd) ||
            _sprites.trap(_lev.trap3.tx[i], _lev.trap3.ty[i], lcd) ||
            _sprites.trap(_lev.trap4.tx[i], _lev.trap4.ty[i], lcd) ||
            _sprites.trap(_lev.trap5.tx[i], _lev.trap5.ty[i], lcd)) {
        return true;
    }
    return false;
}

// draws keys and checks if collision with player
void Gameengine::key_draw(N5110 &lcd, Gamepad &pad)
{
    int i = _level; // tells function which level settings to use 
    _sprites.key_collect(0, _lev.key1.kx[i], _lev.key1.ky[i], lcd, pad);
    _sprites.key_collect(1, _lev.key2.kx[i], _lev.key2.ky[i], lcd, pad);
    _sprites.key_collect(2, _lev.key3.kx[i], _lev.key3.ky[i], lcd, pad);
    _sprites.key_collect(3, _lev.key4.kx[i], _lev.key4.ky[i], lcd, pad);
    _sprites.key_collect(4, _lev.key5.kx[i], _lev.key5.ky[i], lcd, pad);
}


// places and checks for collision with sinking and solid blocks
void Gameengine::blocks(N5110 &lcd)
{
    int i = _level; // tells function which level settings to use 
    // sinking blocks position length and collision detection
    _sprites.soft_blocks(_lev.sof1.sx1[i], _lev.sof1.sy[i], _lev.sof1.sx2[i], lcd);
    _sprites.soft_blocks(_lev.sof2.sx1[i], _lev.sof2.sy[i], _lev.sof2.sx2[i], lcd);
    _sprites.soft_blocks(_lev.sof3.sx1[i], _lev.sof3.sy[i], _lev.sof3.sx2[i], lcd);
    _sprites.soft_blocks(_lev.sof4.sx1[i], _lev.sof4.sy[i], _lev.sof4.sx2[i], lcd);
    _sprites.soft_blocks(_lev.sof5.sx1[i], _lev.sof5.sy[i], _lev.sof5.sx2[i], lcd);
    // block positions and collision settings, indexed so no conflicts if player is contact with multiple blocks
    _sprites.blocks(_d, 0, _lev.sol1.bx[i], _lev.sol1.by[i], lcd);
    _sprites.blocks(_d, 1, _lev.sol2.bx[i], _lev.sol2.by[i], lcd);
    _sprites.blocks(_d, 2, _lev.sol3.bx[i], _lev.sol3.by[i], lcd);
    _sprites.blocks(_d, 3, _lev.sol4.bx[i], _lev.sol4.by[i], lcd);
    _sprites.blocks(_d, 4, _lev.sol5.bx[i], _lev.sol5.by[i], lcd);
}
// initialises enemies at level start, updates movement, checks collisions 
// indexed (0, 1, 2) so each enemy is treated independently
bool Gameengine::enemies(N5110 &lcd)
{
    int i = _level; // tells function which level settings to use 
    if(_enem_flag == false) {
    // initialises enemy position and distance to move each way
        _sprites.enemy_init(0, _lev.enem1.ex[i], _lev.enem1.ey[i], _lev.enem1.d[i]);
        _sprites.enemy_init(1, _lev.enem2.ex[i], _lev.enem2.ey[i], _lev.enem2.d[i]);
        _sprites.enemy_init(2, _lev.enem3.ex[i], _lev.enem3.ey[i], _lev.enem3.d[i]);
        _enem_flag = true; // stops enemies from being reinitialised constantly
    }
    // enemy velocity
    _sprites.enemy_move(0, _lev.enem1.v[i], lcd);
    _sprites.enemy_move(1, _lev.enem2.v[i], lcd);
    _sprites.enemy_move(2, _lev.enem3.v[i], lcd);
    // checks if collision
    if(_sprites.enemy_collision(0) || _sprites.enemy_collision(1) ||
            _sprites.enemy_collision(2)) {
        return true;
    }
    return false;
}

// reinitialises keys when level complete
void Gameengine::key_reinit()
{
    if(_key_reinit == false) {
        for(int i = 0; i<5; i++) {
            _sprites._key[i] = false;
        }
        _key_reinit = true;
    }
}