/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering University of Leeds
Name: Adam P. Baker
Username: el17apb
Student ID Number: 201166301 
Date: 8 May 2019
*/


///////// pre-processor directives /////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "BlockheadEngine.h"
#include "Menu.h"

/////////////// objects ////////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
BlockheadEngine blockhead;
Ticker ticker;
Menu menu;

///////////// prototypes ///////////////
void timer_isr();
void init();
void intro(N5110 &lcd, Gamepad &pad);
void main_menu(N5110 &lcd, Gamepad &pad);
int select_menu_item(Gamepad &pad, N5110 &lcd);
void go_to_main_menu_item(N5110 &lcd, Gamepad &pad, int input);
void menu_playgame(N5110 &lcd, Gamepad &pad);
void menu_highscore(N5110 &lcd, Gamepad &pad);
void menu_settings(N5110 &lcd, Gamepad &pad);
void menu_quit(N5110 &lcd, Gamepad &pad);
void select_continue_menu_item(N5110 &lcd, Gamepad &pad, int input);
void menu_continue(N5110 &lcd, Gamepad &pad);

volatile int timer_flag = 0;                                            //sets timer_flag to 0


///////////// functions ////////////////
int main()
{

    int fps = 6;                                                        //sets fps to 6
    init();
    ticker.attach(&timer_isr,1.0f/fps);                                 //creates a ticker and attaches it to timer_isr (ticks 6 * per second)

    lcd.setContrast(0.55);                                              //intialy sets contrast to 0.55

    intro(lcd, pad);                                                    //runs intro sequence

    main_menu(lcd, pad);                                                //runs main menu ( finite state machine, states also include "play game" "highscore" "settings" and "quit..." )
 
}


//sets the timer_flag to 1
void timer_isr()                                                        
{

    timer_flag = 1;                                                     // set flag in ISR
}


//intialises variables of below classes
void init()                                                             
{
    pad.init();                                                         //intialise Gamepad class variables
    lcd.init();                                                         //intialise N5110 class variables
    menu.init();                                                        //intialise menu variables
}


//runs the intro sequence 
void intro(N5110 &lcd, Gamepad &pad)                                               
{
    menu.title_intro(lcd, pad);                                         //runs 'BLOCK HEAD' intro sequence
    int start = 0;

    do {
        if (timer_flag == true) {                                       //only run when timer flag is true (6fps)

            timer_flag = 0;

            start = menu.press_start(lcd, pad);                         //flashes start untill start button is pressed

        } else {

            sleep();                                                    //sleep when timer_flag not true in order to conserve energy

        }


    } while (start == 0);

    menu.init();                                                        //intilises menu variables
}


//main menu state
void main_menu(N5110 &lcd, Gamepad &pad)                                
{

    blockhead.init();                                                   //intialise blockhead engine variables for new game
    int input = select_menu_item(pad, lcd);                             //reads input and prints the main menu
    go_to_main_menu_item(lcd, pad, input);                              //peforms what ever input is chosen
}


//reads input and prints main menu
int select_menu_item(Gamepad &pad, N5110 &lcd)                          
{
    int input = 0;
    do {

        if (timer_flag == true) {                                       //only run when timer flag is true (6fps)

            timer_flag = 0;

            input = menu.select_input_main(pad, lcd);                   //runs until input is selected

        } else {

            sleep();                                                    //sleep when timer_flag not true in order to conserve energy
    
        }       
    } while (input == 0);                                               //repeats untill an input is chosen

    return input;
}


//depending on input, goes to following menu items
void go_to_main_menu_item(N5110 &lcd, Gamepad &pad, int input)          
{
    switch (input) {                                                   
        case 1:
            menu_playgame(lcd, pad);
            break;
        case 2:
            menu_highscore(lcd, pad);
            break;
        case 3:
            menu_settings(lcd, pad);
        case 4:
            menu_quit(lcd, pad);
        default:
            exit(1);
            break;
    }
}


//runs playgame menu state
void menu_playgame(N5110 &lcd, Gamepad &pad)                           
{
    int gameover = 0;

    do {
        if (timer_flag == true) {                                       //only run when timer flag is true (6fps)

            timer_flag = 0;                                             //if it has, clear the flag

            gameover = blockhead.playgame(lcd, pad);                    //run game untill gameover

        } else {

            sleep();                                                    //sleep when timer_flag not true in order to conserve energy

        }
    } while (gameover == 0);

    menu_continue(lcd, pad);                                            //once gameover occurs, go to continue menu 

}


//runs highscore menu state
void menu_highscore(N5110 &lcd, Gamepad &pad)                           
{

    int goback = 0;

    do {

            if (timer_flag == true) {                                   //only run when timer flag is true (6fps)

            timer_flag = 0;                                             //if it has, clear the flag

            int highscore = blockhead.highscore();                      //gets high score from blockhead engine   

            menu.print_highscore(lcd, highscore);                       //prints high score menu, with high score

            if (pad.check_event(Gamepad::B_PRESSED) || pad.check_event(Gamepad::BACK_PRESSED)) {            //B or Back button to go back to main menu
                goback = 1;
            }

        } else {

            sleep();                                                    //sleep when timer_flag not true in order to conserve energy

        }
    } while (goback == 0);

    main_menu(lcd, pad);                                                //once b or back pressed, go to main menu
}


//runs settings menu state
void menu_settings(N5110 &lcd, Gamepad &pad)                            
{

    int goback = 0;
    float contrast;

    do {

        if (timer_flag == true) {                                       //only run when timer flag is true (6fps)

            timer_flag = 0;                                             //if it has, clear the flag

            contrast = menu.print_settings(pad, lcd);                   //run comtast menu and return contast
            lcd.setContrast(contrast);                                  //update lcd contast
            
            if (pad.check_event(Gamepad::B_PRESSED) || pad.check_event(Gamepad::BACK_PRESSED)) {
                goback = 1;
            }

        } else {

            sleep();                                                    //sleep when timer_flag not true in order to conserve energy

        }
    } while (goback == 0);
    main_menu(lcd, pad);                                                //go to main menu once b or back is pressed 
}

void menu_quit(N5110 &lcd, Gamepad &pad)
{
    lcd.turnOff();
    sleep();

}


//depending on input, goes to following continue menu items
void select_continue_menu_item(N5110 &lcd, Gamepad &pad, int input)     
{
    switch (input) {
        case 1:
            menu_playgame(lcd, pad);                                    //if play game, level will be the one you were just on
            break;
        case 2:
            main_menu(lcd, pad);                                        //if menu, game resets
            break;
        default:
            exit(1);
            break;
    }
}


//runs continue game state
void menu_continue(N5110 &lcd, Gamepad &pad)                            
{
    blockhead.continue_init();                                           //intialised continue game variables (level does not change)
    menu.init();

    int input = 0;
    do {

        if (timer_flag == true) {                                       //only run when timer flag is true (6fps)

            timer_flag = 0;                                             //if it has, clear the flag

            input = menu.select_input_continue(pad, lcd);               //prints continue menu, and selects coninue menu item

        }   else {

            sleep();                                                    //sleep when timer_flag not true in order to conserve energy

        }
    } while (input == 0);
    select_continue_menu_item(lcd, pad, input);                         //go to what ever item has been selected
}

